/* eslint-disable @typescript-eslint/no-explicit-any */
"use client";

import { ReactNode } from "react";
import { NextIntlClientProvider } from "next-intl";
import { Provider } from "react-redux";
import store from "@/lib/services/redux/store";
import LayoutController from "@/components/LayoutController/LayoutController";
import { LocalizationProvider } from "@mui/x-date-pickers";
import { AdapterDateFns } from "@mui/x-date-pickers/AdapterDateFns";
import "@/styles/styles.scss";

const Main = ({
  children,
  locale,
  messages,
}: {
  children: ReactNode;
  locale: string;
  messages: any;
}) => {
  return (
    <LocalizationProvider dateAdapter={AdapterDateFns}>
      <NextIntlClientProvider
        timeZone="America/Mexico_City"
        onError={(error) => {
          if (error.code === "MISSING_MESSAGE") return;
          console.error(error);
        }}
        locale={locale}
        messages={messages}
      >
        <LayoutController>{children}</LayoutController>
      </NextIntlClientProvider>
    </LocalizationProvider>
  );
};

export default function ClientLayout(props: {
  children: ReactNode;
  locale: string;
  messages: any;
}) {
  return (
    <Provider store={store}>
      <Main {...props} />
    </Provider>
  );
}
