import { CustomDocumentPickerResponse } from "@/components/FormInput/types";

export interface createPropertyFormData {
  //step 1
  title: string;
  propertyType: string;
  operationType: string;
  complex: string;
  identifier: string;

  country: string;
  state: string;
  city: string;

  location: {
    lat: number;
    lng: number;
  };
  locationCenter?: {
    lat: number;
    lng: number;
  };

  price: number;

  //step 2
  age: number | null;
  builtArea: number | null; // m² of construction
  landArea: number | null; // m² of land

  bedrooms: number | null;
  fullBathrooms: number | null;
  halfBathrooms: number | null;

  parkingSpots: number | null;
  floors: number | null;

  hasWater: number | null;
  hasElectricity: number | null;
  hasGas: number | null;
  hasInternet: number | null;

  privateSecurity: number | null;
  nearbySchools: number | null;
  maintenanceIncluded: number | null;
  accessibleForDisabled: number | null;

  hasPool: number | null;
  hasSecurityCameras: number | null;

  furnished: 0 | 1;

  beds: number | null;
  closet: number | null;
  livingroom: number | null;
  diningroom: number | null;
  kitchen: number | null;
  aa: number | null;
  refrigerator: number | null;
  stove: number | null;
  microwave: number | null;
  minioven: number | null;
  oven: number | null;
  washingmachine: number | null;
  driyingmachine: number | null;
  others: string | null;

  description: string;

  //step 2
  addVideo: 0 | 1;
  propertyFiles: CustomDocumentPickerResponse[];
}
