import { createPropertyFormData } from "../../../components/CreatePropertyForm/types";

export const validatorsByStep = {
  common: [
    ({
      country,
      state,
      city,
      title,
    }: Partial<createPropertyFormData>): string[] => {
      const labels: string[] = [];

      if (!title || title.length === 0) {
        labels.push("El titulo es requerido");
      }
      if (!country || country.length === 0) {
        labels.push("El pais es requerido");
      }
      if (!state || state.length === 0) {
        labels.push("El estado es requerido");
      }
      if (!city || city.length === 0) {
        labels.push("la ciudad es requerida");
      }

      return labels;
    },
    ({ description }: Partial<createPropertyFormData>): string[] => {
      const labels: string[] = [];

      if (!description || description.length === 0) {
        labels.push("La descripcion es requerida");
      }
      if (description && description.split(" ").length < 100) {
        labels.push("La descripcion debe tener al menos 100 palabras.");
      }

      return labels;
    },
    (): string[] => {
      const labels: string[] = [];

      return labels;
    },
  ],
};
