import React from "react";
import styles from "./styles/CustomCodeInput.module.scss";
import OtpInput, { OTPInputProps } from "react-otp-input";

interface CustomCodeInputsProps {
  codefieldProps: Omit<OTPInputProps, "renderInput">;
  CELL_COUNT: number;
  errorMode?: boolean;
}

const CustomCodeInput: React.FC<CustomCodeInputsProps> = ({
  CELL_COUNT = 6,
  codefieldProps,
}) => {
  return (
    <OtpInput
      {...codefieldProps}
      numInputs={CELL_COUNT}
      renderInput={(props) => <input {...props} className={styles.input} />}
    />
  );
};

export default CustomCodeInput;
