import { DatePicker, MobileDatePicker } from "@mui/x-date-pickers";
import React from "react";
import styles from "./styles/DateComponent.module.scss";
import { SECONDARY_COLOR } from "@/styles/constants";

export interface DateComponentProps {
  onChange: (event: { target: { value: Date | null } }) => void;
  value: Date | null;
  id?: string;
  disablePast?: boolean;
  disableFuture?: boolean;
  className?: string;
  name?: string;
  noBorder?: boolean;
  minDate?: Date;
  disableWeekends?: boolean;
}

const DateComponent: React.FC<DateComponentProps> = ({
  onChange,
  value,
  disablePast = false,
  disableFuture = false,
  className,
  name,
  noBorder = false,
  minDate,
  disableWeekends,
}) => {
  const handleDateChange = (date: Date | null) => {
    onChange({ target: { value: date } });
  };

  const shouldDisableDate = (date: Date) => {
    if (!disableWeekends) return false;
    const day = date.getDay();
    return day === 0;
  };

  return (
    <>
      <div className={styles.dateComponent}>
        <DatePicker
          className={className}
          name={name}
          format="dd/MM/yyyy"
          disablePast={disablePast}
          disableFuture={disableFuture}
          value={value}
          minDate={minDate}
          shouldDisableDate={shouldDisableDate}
          localeText={{
            cancelButtonLabel: "Cancelar",
            okButtonLabel: "Aceptar",
            toolbarTitle: "Selecciona una fecha",
          }}
          onChange={handleDateChange}
          sx={{
            width: "100%",
            "& .MuiInputBase-root": {
              width: "100%",
              padding: "0",
            },
            "& .MuiOutlinedInput-input": {
              padding: 0, // Elimina el padding
              fontFamily: "Raleway",
              fontSize: "13px",
              color: SECONDARY_COLOR,
            },
            "& .MuiOutlinedInput-notchedOutline": noBorder
              ? {
                  border: "none",
                  padding: "0",
                }
              : {},
          }}
        />
      </div>
      <div className={styles.dateComponentResponsive}>
        <MobileDatePicker
          className={className}
          name={name}
          format="dd/MM/yyyy"
          disablePast={disablePast}
          disableFuture={disableFuture}
          minDate={minDate}
          shouldDisableDate={shouldDisableDate}
          localeText={{
            cancelButtonLabel: "Cancelar",
            okButtonLabel: "Aceptar",
            toolbarTitle: "Selecciona una fecha",
          }}
          value={value}
          onChange={handleDateChange}
          sx={{
            width: "100%",
            "& .MuiInputBase-root": {
              width: "100%",
            },
            "& .MuiOutlinedInput-input": {
              padding: 0, // Elimina el padding
              fontFamily: "Raleway",
              color: SECONDARY_COLOR,
            },
            "& .MuiOutlinedInput-notchedOutline": noBorder
              ? {
                  border: "none",
                }
              : {},
          }}
        />
      </div>
    </>
  );
};

export default DateComponent;
