/* eslint-disable @typescript-eslint/no-explicit-any */
import React from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableHead,
  TableRow,
  Paper,
  Skeleton,
} from "@mui/material";
import styles from "./styles/DynamicTable.module.scss";
import { BasicModelStructure } from "@/types/main/types";
import { useTranslations } from "next-intl";

export interface DynamicTableTabsProps {
  label: string;
  key: string;
  onClick: (id: string) => any;
}

export interface Column<T> {
  id: string;
  label: keyof T | string;
  render?: (row: T) => React.ReactNode;
}

interface DynamicTableProps<T> {
  columns: Column<T>[];
  data: any[];
  children?: React.ReactNode;
  loading?: boolean;
  tabsIndex?: number;
  tabs?: DynamicTableTabsProps[];
}

const DynamicTable = <T extends BasicModelStructure>({
  columns,
  data,
  tabs,
  tabsIndex,
  loading,
}: DynamicTableProps<T>) => {
  const t = useTranslations();

  return (
    <>
      <div style={{ width: "100%" }}>
        {tabs && tabs.length > 0 && (
          <div className={styles.tabsContainer}>
            {tabs?.map((t, index) => {
              return (
                <div
                  key={index}
                  className={
                    tabsIndex === index ? styles.tab_selected : styles.tab
                  }
                  onClick={() => t.onClick(t.key)}
                >
                  <p>{t.label}</p>
                </div>
              );
            })}
          </div>
        )}
        <div className={styles.tableWrapper}>
          <TableContainer
            component={Paper}
            className={styles.tablecontainer}
            elevation={0}
          >
            <Table sx={{ borderCollapse: "collapse" }} className={styles.table}>
              <TableHead sx={{ borderBottom: "none", background: "#F4F6F8" }}>
                <TableRow>
                  {columns.map((column, index) => (
                    <TableCell
                      key={column.id}
                      className={styles.cells}
                      sx={{
                        borderBottom: "1px solid #FFF",
                        borderRight:
                          index < columns.length - 1
                            ? "1px solid #FFF"
                            : "none",
                        background: "#444445",
                      }}
                    >
                      <div
                        className={styles.cellInner}
                        style={{ color: "#FFF" }}
                      >
                        <b>{t(column?.label as string)}</b>
                      </div>
                    </TableCell>
                  ))}
                </TableRow>
              </TableHead>
              <TableBody>
                {(loading ? Array(5).fill({}) : data).map((row, rowIndex) => (
                  <TableRow key={rowIndex}>
                    {columns.map((column, index) => (
                      <TableCell
                        key={column.id}
                        className={styles.cells}
                        sx={{
                          padding: "0 !important",
                          borderBottom:
                            rowIndex < (loading ? 4 : data.length - 1)
                              ? "1px solid #444445"
                              : "none",
                          borderRight:
                            index < columns.length - 1
                              ? "1px solid #444445"
                              : "none",
                        }}
                      >
                        <div className={styles.cellInner}>
                          {loading ? (
                            <Skeleton
                              variant="rectangular"
                              style={{
                                width: "100%",
                                fontSize: "23.3px",
                                borderRadius: "6px",
                              }}
                            />
                          ) : column.render ? (
                            column.render(row)
                          ) : (
                            row[column.id]
                          )}
                        </div>
                      </TableCell>
                    ))}
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </TableContainer>
        </div>
      </div>
    </>
  );
};

export default DynamicTable;
