import React from "react";
import Image from "next/image";
import styles from "./styles.module.scss";
import logo from "../../assets/icons/LogoWhite.svg";
import footerPolygon1 from "../../assets/icons/footerPolygon1.svg";
import footerPolygon2 from "../../assets/icons/footerPolygon2.svg";
import footerPolygon3 from "../../assets/icons/footerPolygon3.svg";
import footerPolygon4 from "../../assets/icons/footerPolygon4.svg";
import { useTranslations } from "next-intl";
import { socials } from "./constants/socials";
import { KeyboardArrowUp } from "@mui/icons-material";
import { IconButton } from "@mui/material";

const Footer: React.FC = () => {
  const t = useTranslations();

  const handleGoToTop = () => {
    if (typeof window !== "undefined") {
      window.scrollTo({
        top: 0,
        behavior: "smooth",
      });
    }
  };

  return (
    <div className={styles.container}>
      <Image
        src={footerPolygon2}
        className={styles.footerPolygon3}
        alt="Fieloo logo"
      />

      <IconButton onClick={handleGoToTop} className={styles.upButton}>
        <KeyboardArrowUp style={{ color: "#000" }} />
      </IconButton>
      <div className={styles.maxContainer}>
        <div className={styles.item} style={{ minWidth: "320px" }}>
          <Image src={logo} alt="Fieloo logo" />
          <p className={styles.title}>{t("followUs")}</p>
          <div className={styles.socials}>
            {socials("", "", "", "", "")
              .slice(1, 7)
              .map((d, index) => {
                return (
                  <div
                    key={index}
                    className={styles.socialButton}
                    onClick={() => window.open(d.link)}
                  >
                    <div className={styles.content}>
                      <Image
                        src={d.image}
                        style={{ maskImage: `url(${d.image})` }}
                        alt={"social" + d.link}
                      />
                    </div>
                  </div>
                );
              })}
          </div>
        </div>
        <div className={styles.item}>
          <p className={styles.title} style={{ marginBottom: "8px" }}>
            Fieloo
          </p>

          <div className={styles.links}>
            <p className={styles.link}>{t("aboutUs")}</p>
            <p className={styles.link}>{t("blog")}</p>
            <p className={styles.link}>{t("termsAndConditions")}</p>
            <p className={styles.link}>{t("myProperties")}</p>
            <p className={styles.link}>{t("myProfile")}</p>
          </div>
        </div>
        <div className={styles.item}>
          <p className={styles.title} style={{ marginBottom: "8px" }}>
            {t("contact")}
          </p>

          <div className={styles.links}>
            <p className={styles.link}>{t("email")}: contacto@fieloo.com</p>
            <p className={styles.link}>
              {t("address")}: Miguel Ángel 16, Villas del Arte, 77500, Benito
              Juárez, Cancún
            </p>
            <p className={styles.link}>{t("phone")}: 55 1971 3247</p>
          </div>
        </div>
        <Image
          src={footerPolygon4}
          className={styles.footerPolygon4}
          alt="Fieloo logo"
        />
        <Image
          src={footerPolygon3}
          className={styles.footerPolygon2}
          alt="Fieloo logo"
        />
        <Image
          src={footerPolygon1}
          className={styles.footerPolygon1}
          alt="Fieloo logo"
        />
      </div>
      <div className={styles.secondPart}>
        <p>Copyright © 2025 Fieloo. {t("copyright")}.</p>
      </div>
    </div>
  );
};

export default Footer;
