import React, { useMemo, useRef, useState } from "react";
import styles from "./styles/FormInput.module.scss";
import { FormInputVariations } from "./types";
import CustomSelector from "../CustomSelector/CustomSelector";
import TitleAndSubtitle from "../TitleAndSubtitle/TitleAndSubtitle";
import CustomCodeInput from "../CustomCodeInput/CustomCodeInput";
import {
  Button,
  CircularProgress,
  FormControlLabel,
  IconButton,
  InputBase,
  Radio,
  Switch,
} from "@mui/material";
import DeleteIcon from "@mui/icons-material/Delete";
import SwapHorizIcon from "@mui/icons-material/SwapHoriz";
import {
  AccessTime,
  Add,
  AddCircleOutline,
  ArrowBack,
  Close,
  KeyboardArrowDownRounded,
  VisibilityOffOutlined,
  VisibilityOutlined,
} from "@mui/icons-material";
import DateComponent from "../DateComponent/DateComponent";
import GoogleMapComponent from "../GoogleMapComponent/GoogleMapComponent";
import { addDays, format } from "date-fns";
import { CalendarIcon, DatePicker, TimePicker } from "@mui/x-date-pickers";
import { useTranslations } from "next-intl";
import { PRIMARY_COLOR, WHITE } from "@/styles/constants";
import createId from "@/lib/utils/create-id";
import Image from "next/image";

export interface CurrentFormInputProps {
  label?: string;
  required: boolean;
  hideOnPrint?: boolean;
  showError?: boolean;
  minWidth?: string;
  maxWidth?: string;
  variationConfig?: FormInputVariations;
  children?: React.ReactNode;
}

const RequiredMark = () => <span className={styles.requiredMark}> * </span>;

const FormInput: React.FC<CurrentFormInputProps> = ({
  label,
  required,
  showError,
  hideOnPrint,
  variationConfig: props,
}) => {
  const t = useTranslations();
  const [focus, setfocus] = useState(false);
  const [showPassword, setShowPassword] = useState(true);
  const [openDropdown, setOpenDropdown] = useState<
    React.MouseEvent<HTMLDivElement>["currentTarget"] | null
  >(null);
  const [showTemporalCoverForGalleryItem, setShowTemporalCoverForGalleryItem] =
    useState<string>();

  const fileInputRef = useRef<HTMLInputElement>(null);

  const customTimepickerAnchorRef = useRef<HTMLDivElement | null>(null);
  const [openTimepicker, setOpenTimepicker] = useState(false);
  const [openDateRangePicker1, setOpenDateRangePicker1] = useState(false);
  const [openDateRangePicker2, setOpenDateRangePicker2] = useState(false);

  const render = useMemo(() => {
    if (props?.type === "identification") {
      return (
        <div className={styles.containerIdentification} style={{ gap: 30 }}>
          {props.cardProps.filter((card) => card.front || card.back).length >
            0 &&
            props.cardProps.map((card) => (
              <div
                key={card.id}
                className={styles.containerIdentification}
                style={{ minHeight: 100 }}
              >
                {(card.front || card.back) && (
                  <>
                    <TitleAndSubtitle title={card.type} />
                    <button
                      className={styles.buttonsCards}
                      onAuxClick={() => {
                        setShowTemporalCoverForGalleryItem(card.id + "front");
                        setTimeout(() => {
                          setShowTemporalCoverForGalleryItem(undefined);
                        }, 6000);
                      }}
                    >
                      {!!card.front && (
                        <>
                          <Image
                            src={card.front}
                            className={styles.galleryPreviewImage}
                            alt="cardfront"
                          />
                          {showTemporalCoverForGalleryItem ===
                            card.id + "front" && (
                            <div className={styles.imageShadow}>
                              <IconButton
                                className={styles.deleteIconButton}
                                onClick={() => props.onDelete(card.id)}
                              >
                                <DeleteIcon htmlColor="#FF3030" />
                              </IconButton>
                            </div>
                          )}
                        </>
                      )}
                    </button>
                    {card.type !== "Pasaporte" && card.type !== "Otro" && (
                      <button
                        className={styles.buttonsCards}
                        onAuxClick={() => {
                          setShowTemporalCoverForGalleryItem(card.id + "back");
                          setTimeout(() => {
                            setShowTemporalCoverForGalleryItem(undefined);
                          }, 6000);
                        }}
                      >
                        {!!card.back && (
                          <>
                            <Image
                              src={card.back}
                              className={styles.galleryPreviewImage}
                              alt="cardback"
                            />
                            {showTemporalCoverForGalleryItem ===
                              card.id + "back" && (
                              <div className={styles.imageShadow}>
                                <IconButton
                                  className={styles.deleteIconButton}
                                  onClick={() => props.onDelete(card.id)}
                                >
                                  <DeleteIcon htmlColor="#FF3030" />
                                </IconButton>
                              </div>
                            )}
                          </>
                        )}
                      </button>
                    )}
                  </>
                )}
              </div>
            ))}
          {!props.cardProps.filter((card) => card.front || card.back)
            .length && (
            <p className={styles.noIdentification}>{t("noIdentifications")}</p>
          )}
        </div>
      );
    }

    if (props?.type === "gallery") {
      return (
        <div
          className={styles.container}
          style={{ width: "100%", maxWidth: "100%" }}
        >
          <div className={styles.formInputCards}>
            <div className={styles.buttons} onClick={props.addFunc}>
              <Add htmlColor={WHITE} style={{ fontSize: "80px" }} />
              <p className={styles.buttonText}>{t("addNewBook")}</p>
            </div>
            {props.files.map((file) => (
              <div
                key={file.name}
                className={styles.buttons}
                onClick={() =>
                  props.pressAlbum(file.data ?? (file?.id as string))
                }
              >
                {file.thumbnail && (
                  <>
                    <Image
                      src={file.thumbnail ? file.thumbnail : ""}
                      className={styles.galleryPreviewImage}
                      alt="thumbnail"
                    />
                    <div className={styles.imageShadow} />
                  </>
                )}
                <p className={styles.buttonText}>{file.name}</p>
                <p className={styles.buttonText} style={{ fontWeight: 400 }}>
                  {file?.files ?? 0} {t("photos")}
                </p>
              </div>
            ))}
          </div>
        </div>
      );
    }

    if (props?.type === "gallery_open") {
      return (
        <div
          className={styles.container}
          style={{ width: "100%", maxWidth: "100%" }}
        >
          <div className={styles.openGalleryHeader}>
            <IconButton className={styles.backButton} onClick={props.back}>
              <ArrowBack htmlColor="#7a7a7a" />
            </IconButton>
            <p className={styles.openGalleryHeaderText}>{props.title}</p>
          </div>
          <div className={styles.formInputCards}>
            <div className={styles.buttonsGalleryOpen} onClick={props.addFunc}>
              <Add htmlColor={WHITE} style={{ fontSize: "80px" }} />
              <p className={styles.buttonText}>{t("addPhoto")}</p>
            </div>
            {props.files.map((file) => (
              <div
                key={file.id}
                className={styles.buttonsGalleryOpen}
                onAuxClick={() => {
                  setShowTemporalCoverForGalleryItem(file.id);
                  setTimeout(() => {
                    setShowTemporalCoverForGalleryItem(undefined);
                  }, 6000);
                }}
              >
                {file.name && (
                  <>
                    <Image
                      src={file.name}
                      className={styles.galleryImage}
                      alt="gallery"
                    />
                    {showTemporalCoverForGalleryItem === file.id && (
                      <div className={styles.imageShadow}>
                        {props.switchPhoto && (
                          <IconButton
                            className={styles.switchButton}
                            onClick={() =>
                              props.switchPhoto && props.switchPhoto(file.id)
                            }
                          >
                            <SwapHorizIcon
                              sx={{ fontSize: "50px" }}
                              htmlColor="#FFF"
                            />
                          </IconButton>
                        )}
                        <IconButton
                          className={styles.deleteIconButton}
                          onClick={() => props.deletePhoto(file.id)}
                        >
                          <DeleteIcon htmlColor="#FF3030" />
                        </IconButton>
                      </div>
                    )}
                  </>
                )}
              </div>
            ))}
          </div>
        </div>
      );
    }

    if (props?.type === "file_list_attacher") {
      const handleFileSelection = async (
        event: React.ChangeEvent<HTMLInputElement>
      ) => {
        const file = event.target.files?.[0];

        if (
          file &&
          props.setFiles &&
          event.target.files &&
          event.target.files?.length > 0
        ) {
          props.setFiles(
            Array.from(event.target.files)
              ?.map((file) => {
                return {
                  id: createId(),
                  name: file.name,
                  type: file.type,
                  uri: URL.createObjectURL(file),
                  date: new Date(),
                };
              })
              .splice(0, props.maxFiles ?? 1)
          );
        }
      };

      return (
        <div
          className={styles.container}
          style={
            props.fullWidth
              ? {
                  width: "100%",

                  maxWidth: "100%",
                }
              : {}
          }
        >
          {/* {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
              {!!props.labelIcon && (
                <p className={styles.label}>{props.labelIcon}</p>
              )}
            </p>
          )} */}
          <div className={styles.filesContainer}>
            <div
              className={styles.dropzone}
              style={{
                borderColor: showError ? "red" : undefined,
                cursor: "pointer",
              }}
              onClick={() => fileInputRef.current?.click()}
            >
              <AddCircleOutline htmlColor="#fff" sx={{ fontSize: "149px" }} />
              <p className={styles.text}>{t("attachYourFilesHere")}</p>
            </div>
            {props.bottomText && (
              <p className={styles.bottomText}>{props.bottomText}</p>
            )}
            {Boolean(props?.files?.length) && (
              <div className={styles.filelistContainer}>
                {props.files.map((item, index) => (
                  <React.Fragment key={item.id}>
                    <div className={styles.fileItemContainer}>
                      <div
                        className={styles.fileItem}
                        style={{ backgroundImage: `url(${item.uri})` }}
                      >
                        <p className={styles.fileItemText}>
                          {/* {item.name.length > 7
                            ? item.name.split(".")[0].slice(0, 7) + "..."
                            : item.name.split(".")[0]}
                          {item.type ? "." + item.type.split("/")[1] : ""} */}
                        </p>
                        <IconButton
                          className={styles.deleteFileButton}
                          onClick={() => {
                            if (props.deleteFile) props.deleteFile(item.id);
                          }}
                        >
                          <Close htmlColor="#fff" sx={{ fontSize: "20px" }} />
                        </IconButton>
                      </div>
                      <p className={styles.fileNumber}>{index + 1}</p>
                    </div>
                  </React.Fragment>
                ))}
              </div>
            )}
          </div>

          <input
            type="file"
            ref={fileInputRef}
            hidden
            multiple
            style={{ display: "none" }}
            onChange={handleFileSelection}
          />
        </div>
      );
    }

    if (props?.type === "selector") {
      const handleMountSelector = (event: React.MouseEvent<HTMLDivElement>) =>
        setOpenDropdown(openDropdown ? null : event.currentTarget);
      return (
        <div
          className={
            props?.width30percent ? styles.container30percent : styles.container
          }
          style={
            props.fullWidth
              ? {
                  width: "100%",
                  maxWidth: "100%",
                }
              : {}
          }
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div
            className={styles.radiosContainer}
            onClick={props.inputProps.onClick ?? handleMountSelector}
          >
            <div
              className={styles.textInputContainer}
              style={{
                borderColor: showError ? "red" : undefined,
                ...props.inputProps.style,
              }}
            >
              <p className={styles.selectInnerTab}>
                {props?.inputProps?.selectedItem ||
                (typeof props?.inputProps?.selectedItem === "number" &&
                  props?.inputProps?.selectedItem === 0) ||
                props?.inputProps.multiple
                  ? props.inputProps?.multiple &&
                    props.inputProps?.selectedItems?.length
                    ? (props.inputProps?.selectedItems ?? [])
                        ?.map(
                          (hash) =>
                            props?.inputProps?.options.find(
                              (d) => d.value === hash
                            )?.label
                        )
                        .join(", ")
                    : props?.inputProps?.options.find(
                        (d) => d.value === props?.inputProps.selectedItem
                      )?.label ?? props?.inputProps.placeholder
                  : props?.inputProps.placeholder}
              </p>
              {props.inputProps.iconEnd && (
                <Image src={props.inputProps.iconEnd} alt={"icon"} />
              )}
              {!props.inputProps.iconEnd && (
                <div className={styles.keyboardArrowDown}>
                  <KeyboardArrowDownRounded
                    htmlColor={"#000"}
                    style={{ fontSize: "30px" }}
                  />
                </div>
              )}
              <CustomSelector
                {...props.inputProps}
                selectedItem={props.inputProps.selectedItem}
                onlyDropdown
                openOnlyDropdown={openDropdown}
                setOpenDropdown={setOpenDropdown}
              />
            </div>
          </div>
        </div>
      );
    }

    if (props?.type === "date_picker") {
      return (
        <div
          className={styles.container}
          style={
            props.fullWidth
              ? {
                  width: "100%",

                  maxWidth: "100%",
                }
              : {}
          }
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div className={styles.radiosContainer}>
            <div
              className={styles.textInputContainer}
              style={{
                borderColor: showError ? "red" : "",
              }}
            >
              {/* <p className={styles.selectInnerTab}>
                {props?.inputProps?.value
                  ? format(new Date(props?.inputProps?.value), "dd/MM/yyyy")
                  : "dd/MM/yyyy"}
              </p> */}
              <DateComponent
                {...props.inputProps}
                noBorder
                className={styles.dateInput}
              />
              {/* <CalendarMonth
                htmlColor={PRIMARY_COLOR}
                style={{ fontSize: "20px" }}
              /> */}
            </div>
          </div>
        </div>
      );
    }

    if (props?.type === "range_date_picker") {
      return (
        <div
          className={styles.container}
          style={
            props.fullWidth
              ? {
                  width: "100%",

                  maxWidth: "100%",
                }
              : {}
          }
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div className={styles.radiosContainer}>
            <div
              className={styles.textInputContainer}
              ref={customTimepickerAnchorRef}
              onClick={() => {
                setOpenDateRangePicker1(true);
              }}
              style={{
                borderColor: showError
                  ? "red"
                  : focus
                  ? PRIMARY_COLOR
                  : "#A4A8BB",
              }}
            >
              <p className={styles.selectInnerTab}>
                {props?.inputProps?.value?.[0]
                  ? format(
                      props?.inputProps?.value?.[0] ?? new Date(),
                      "dd/MM/yyyy"
                    )
                  : "--/--/---"}
                {"    -    "}
                {props?.inputProps?.value?.[1]
                  ? format(
                      props?.inputProps?.value?.[1] ?? new Date(),
                      "dd/MM/yyyy"
                    )
                  : "--/--/---"}
              </p>
              <CalendarIcon
                htmlColor={PRIMARY_COLOR}
                style={{ fontSize: "20px" }}
              />
            </div>
            {openDateRangePicker1 && (
              <DatePicker
                {...props.inputProps}
                value={props?.inputProps?.value[0]}
                onChange={(newValue) => {
                  if (props?.inputProps?.onChange && newValue) {
                    props?.inputProps?.onChange(newValue, 0);
                    setOpenDateRangePicker1(false);
                    setOpenDateRangePicker2(true);
                  }
                }}
                open={openDateRangePicker1}
                slots={{
                  textField: () => null,
                }}
                slotProps={{
                  popper: {
                    anchorEl: customTimepickerAnchorRef.current,
                  },
                }}
              />
            )}
            {openDateRangePicker2 && (
              <DatePicker
                {...props.inputProps}
                value={props?.inputProps?.value[1]}
                minDate={addDays(props?.inputProps?.value[0], 1)}
                onChange={(newValue) => {
                  if (props?.inputProps?.onChange && newValue) {
                    props?.inputProps?.onChange(newValue, 1);
                    setOpenDateRangePicker2(false);
                  }
                }}
                open={openDateRangePicker2}
                slots={{
                  textField: () => null,
                }}
                slotProps={{
                  popper: {
                    anchorEl: customTimepickerAnchorRef.current,
                  },
                }}
              />
            )}
          </div>
        </div>
      );
    }

    if (props?.type === "radios-group") {
      return (
        <div
          className={styles.container}
          style={
            props.fullWidth
              ? {
                  width: "100%",

                  maxWidth: "100%",
                }
              : {}
          }
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div className={styles.radiosContainer}>
            {props.radios.map((d) => (
              <div
                key={d.label}
                className={styles.radioContainer}
                style={{
                  // flex: props.flex ? 1 : "none",
                  minWidth: props.flex ? "30%" : "none",
                  maxWidth: props.flex ? "30%" : "none",
                }}
              >
                <FormControlLabel
                  value={d.value}
                  control={<Radio checked={d.checked} />}
                  label={d.label}
                  onClick={() => d.onClick(d.value)}
                  className={styles.radioContainerText}
                />
              </div>
            ))}
          </div>
        </div>
      );
    }

    if (props?.type === "select_input") {
      const handleMountSelector = (event: React.MouseEvent<HTMLDivElement>) =>
        setOpenDropdown(openDropdown ? null : event.currentTarget);

      return (
        <div
          className={styles.container}
          style={props.fullWidth ? { width: "100%", maxWidth: "100%" } : {}}
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div
            className={styles.selectInputContainer}
            style={{
              borderColor: showError
                ? "red"
                : focus
                ? PRIMARY_COLOR
                : "#A4A8BB",
            }}
          >
            <div
              className={styles.selectInputSelectPart}
              onClick={handleMountSelector}
            >
              <p className={styles.selectInputSelectPartText}>
                {props?.select?.selectedItem
                  ? props?.select?.options.find(
                      (d) => d.value === props?.select?.selectedItem
                    )?.label
                  : props.select.placeholder}
              </p>
              <KeyboardArrowDownRounded
                htmlColor={"#000"}
                style={{ fontSize: "30px" }}
              />
              {props.select && (
                <CustomSelector
                  {...props.select}
                  selectedItem={props.select.selectedItem}
                  onlyDropdown
                  openOnlyDropdown={openDropdown}
                  setOpenDropdown={setOpenDropdown}
                />
              )}
            </div>

            <div className={styles.selectInputInputPart}>
              <InputBase
                onFocus={() => setfocus(true)}
                onBlur={() => setfocus(false)}
                {...props.input}
                type={props.input.type}
                onChange={(e) => {
                  if (props?.input?.onChange)
                    props?.input?.onChange({
                      ...e,
                      target: {
                        ...e.target,
                        value:
                          props.input.type === "number"
                            ? e.target.value.toString()
                            : e.target.value,
                      },
                    });
                }}
                placeholder={props.input?.placeholder}
                className={styles.textInput}
              />
            </div>
          </div>
        </div>
      );
    }

    if (props?.type === "text") {
      return (
        <div
          className={styles.container}
          style={props.fullWidth ? { width: "100%", maxWidth: "100%" } : {}}
        >
          {!!label && !props.hideLabel && (
            <span className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </span>
          )}
          <div
            className={
              props.inputProps.variant === "simple"
                ? styles.textInputContainerSimple
                : styles.textInputContainer
            }
            style={{
              borderColor: showError
                ? "red"
                : focus
                ? PRIMARY_COLOR
                : "#A4A8BB",
              ...(props.inputProps.icon ? { paddingLeft: 15 } : {}),
              ...(props.inputProps.passwordMode ? { paddingRight: 10 } : {}),
              ...(props.inputProps.style ?? {}),
            }}
          >
            {props.inputProps.icon && (
              <Image src={props.inputProps.icon} alt={"icon"} />
            )}
            <InputBase
              onFocus={() => setfocus(true)}
              onBlur={() => setfocus(false)}
              {...props.inputProps}
              placeholder={props.inputProps?.placeholder}
              type={
                props.inputProps.passwordMode
                  ? !showPassword
                    ? "text"
                    : "password"
                  : props.inputProps.type ?? "text"
              }
              style={{
                ...props?.inputProps.style,
                height: "fit-content",
                minHeight: "fit-content",
              }}
              onChange={(e) => {
                if (props?.inputProps?.onChange)
                  props?.inputProps?.onChange({
                    ...e,
                    target: {
                      ...e.target,
                      value:
                        props.inputProps.type === "number"
                          ? e.target.value.toString()
                          : e.target.value,
                    },
                  });
              }}
              className={styles.textInput}
            />
            {props.inputProps.iconEnd && (
              <Image src={props.inputProps.iconEnd} alt={"icon"} />
            )}
            {props.inputProps.passwordMode ? (
              <IconButton
                size="small"
                onClick={() => setShowPassword(!showPassword)}
                style={{ marginLeft: 2 }}
              >
                {showPassword ? (
                  <VisibilityOutlined sx={{ fontSize: "13px" }} />
                ) : (
                  <VisibilityOffOutlined sx={{ fontSize: "13px" }} />
                )}
              </IconButton>
            ) : null}
          </div>
          {props.helperText && (
            <span className={styles.helperText}>{props.helperText}</span>
          )}
        </div>
      );
    }

    if (props?.type === "timepicker") {
      return (
        <div
          className={styles.container}
          style={props.fullWidth ? { width: "100%", maxWidth: "100%" } : {}}
        >
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div
            className={styles.textInputContainer}
            ref={customTimepickerAnchorRef}
            onClick={() => setOpenTimepicker(!openTimepicker)}
            style={{
              borderColor: showError
                ? "red"
                : focus
                ? PRIMARY_COLOR
                : "#A4A8BB",
              ...(props.inputProps.icon ? { paddingLeft: 15 } : {}),
              ...(props.inputProps.passwordMode ? { paddingRight: 10 } : {}),
              ...(props.inputProps.style ?? {}),
            }}
          >
            <p className={styles.selectInnerTab}>
              {format(props?.inputProps?.value ?? new Date(), "hh:mm aa")}
            </p>
            <AccessTime
              htmlColor={PRIMARY_COLOR}
              style={{ fontSize: "20px" }}
            />
          </div>
          <TimePicker
            label="Hora"
            {...props.inputProps}
            onChange={(newValue) => {
              if (props?.inputProps?.onChange) {
                props?.inputProps?.onChange(newValue);
                setOpenTimepicker(false);
              }
            }}
            open={openTimepicker}
            onOpen={() => setOpenTimepicker(true)}
            onClose={() => setOpenTimepicker(false)}
            slots={{
              textField: () => null,
            }}
            slotProps={{
              popper: {
                anchorEl: customTimepickerAnchorRef.current,
              },
            }}
          />
        </div>
      );
    }

    if (props?.type === "map") {
      return (
        <div className={styles.mapContainer}>
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <GoogleMapComponent {...props.mapProps} />
        </div>
      );
    }

    if (props?.type === "code_input") {
      return (
        <div className={styles.container}>
          {!!label && !props.hideLabel && (
            <p className={styles.label}>
              {label}
              {required && <RequiredMark />}
            </p>
          )}
          <div className={styles.codeInputContainer}>
            <CustomCodeInput
              errorMode={showError}
              CELL_COUNT={6}
              codefieldProps={props.inputProps}
            />
          </div>
        </div>
      );
    }
    if (props?.type === "switch") {
      return (
        <FormControlLabel
          {...props.formControlLabel}
          control={<Switch {...props.inputProps} />}
        />
      );
    }

    if (props?.type === "divider") {
      return (
        <div
          style={{ alignItems: props?.alignCenter ? "center" : "flex-start" }}
          className={styles.dividerContainer}
        >
          <div className={styles.divider} />
        </div>
      );
    }

    if (props?.type === "title_and_subtitle") {
      return <TitleAndSubtitle {...props?.texts} />;
    }

    if (props?.type === "message_in_card") {
      return (
        <div
          className={styles.messageInCard}
          style={
            props?.cardProps?.color
              ? {
                  boxShadow: `0 0px 10px ${
                    (props?.cardProps?.color ?? PRIMARY_COLOR) + "7a"
                  }`,
                }
              : undefined
          }
        >
          {props.cardProps.title && (
            <p
              className={styles.messageInCardTitle}
              style={{ color: props.cardProps.color ?? "#000" }}
            >
              {props.cardProps.title}
            </p>
          )}
          {props.cardProps.text && (
            <p className={styles.messageInCardText}>{props.cardProps.text}</p>
          )}
        </div>
      );
    }

    if (props?.type === "button") {
      return (
        <div
          className={styles.container}
          style={
            props.fullWidth
              ? { width: "100%", maxWidth: "100%", alignItems: "center" }
              : {}
          }
        >
          {!!props.label && <p className={styles.label}>{props.label}</p>}
          <Button
            className={styles.defaultButtonHover}
            {...props?.button}
            loading={false}
          >
            {props.button?.loading ? (
              <CircularProgress
                style={{ color: props?.button?.style?.color ?? "#fff" }}
                size={14}
              />
            ) : (
              props.button.children
            )}
          </Button>
        </div>
      );
    }

    if (props?.type === "accept_and_cancel") {
      return (
        <div
          className={styles.acceptCancelContainer}
          style={
            props.fullWidth
              ? {
                  width: "100%",
                  maxWidth: "100%",
                  alignItems: "center",
                  justifyContent: "center",
                }
              : {}
          }
        >
          <Button
            className={styles.defaultButtonHover}
            {...props?.cancel}
            loading={false}
          >
            {props.cancel?.loading ? (
              <CircularProgress
                style={{ color: props?.cancel?.style?.color ?? "#fff" }}
                size={14}
              />
            ) : (
              props.cancel.children
            )}
          </Button>
          <Button
            className={styles.defaultButtonHover}
            {...props?.accept}
            loading={false}
          >
            {props.accept?.loading ? (
              <CircularProgress
                style={{ color: props?.accept?.style?.color ?? "#fff" }}
                size={14}
              />
            ) : (
              props.accept.children
            )}
          </Button>
        </div>
      );
    }
  }, [
    focus,
    label,
    openDateRangePicker1,
    openDateRangePicker2,
    openDropdown,
    openTimepicker,
    props,
    required,
    showError,
    showPassword,
    showTemporalCoverForGalleryItem,
    t,
  ]);

  if (props?.type === "children") {
    return (
      <div
        className={
          props?.width30percent ? styles.container30percent : styles.container
        }
        style={
          props.fullWidth
            ? {
                width: "100%",
                maxWidth: "100%",
                alignItems: "center",
              }
            : {}
        }
      >
        {props.children}
      </div>
    );
  }

  if (hideOnPrint)
    return (
      <div className={hideOnPrint ? styles.hideOnPrint : ""}>{render}</div>
    );

  return render;
};

export default FormInput;
