/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { ChangeEvent, ReactSVGElement } from "react";
import { FormControlLabelProps } from "@mui/material";
import { DateComponentProps } from "../DateComponent/DateComponent";
import { OTPInputProps } from "react-otp-input";
import type { ButtonProps as MuiButtonProps, SwitchProps } from "@mui/material";
import { TitleAndSubtitleCompProps } from "../TitleAndSubtitle/TitleAndSubtitle";
import { GoogleMapComponentProps } from "../GoogleMapComponent/GoogleMapComponent";
import { CustomSelectorProps } from "../CustomSelector/CustomSelector";
import { TimePickerComponent } from "@mui/x-date-pickers";

interface TextInputProps {
  value: string | number;
  placeholder: string;
  type?: "text" | "number";
  disabled?: boolean;
  onKeyDown?: React.KeyboardEventHandler<HTMLInputElement> | undefined;
  onChange: (e: ChangeEvent<any>) => any;
}

export interface CustomButtonProps extends MuiButtonProps {
  minWidth?: string;
  maxWidth?: string;
}

export type TEXT_INPUT = "text";
export type TIMEPICKER = "timepicker";
export type CODE_INPUT = "code_input";
export type RADIOS_GROUP = "radios-group";
export type SELECTOR = "selector";
export type FILE_LIST_ATTACHER = "file_list_attacher";
export type DATE_PICKER = "date_picker";
export type RANGE_DATE_PICKER = "range_date_picker";
export type SWITCH = "switch";
export type SELECT_INPUT = "select_input";
export type TITLE_AND_SUBTITLE = "title_and_subtitle";
export type MAP = "map";
export type CHILDREN = "children";
export type BUTTON = "button";
export type DIVIDER = "divider";
export type GALLERY = "gallery";
export type GALLERY_OPEN = "gallery_open";
export type MESSAGE_IN_CARD = "message_in_card";
export type IDENTIFICATION = "identification";
export type ACCEPT_AND_CANCEL = "accept_and_cancel";

export interface IdentificationCompProps {
  id: string;
  type: string;
  front: string;
  back: string;
}

export interface MessageInCardCustomizableProps {
  title: string;
  text: string;
  color: string;
}

export interface PhotosAndBookFileProps {
  name: string;
  link: string;
  created_at?: Date;
}

export interface PhotosAndBookProps {
  data?: string;
  id?: string;
  person_id?: string;
  name: string;
  bookType: string;
  subBookTypes: string;
  files: number;
  thumbnail: string;
}

export interface PhotosProps {
  name: string;
  id: string;
}
export interface RadioProps extends FormControlLabelProps {
  label?: string;
}

export interface SelectOptionsProps {
  label: string;
  value: string;
  name: string;
  divider?: boolean;
  results?: 0;
  is_other?: boolean;
  lat?: number;
  lng?: number;
}

export interface SelectInputProps {
  select: string;
  input: string;
}

export interface FileInputSavedFiles extends CustomButtonProps {
  name: string;
  link: string;
}

export interface FileInputUnsavedFiles extends CustomButtonProps {
  blob: Blob;
}

export interface FormInputCustomTextInputProps extends TextInputProps {
  icon?: ReactSVGElement | any;
  iconEnd?: ReactSVGElement | any;
  passwordMode?: boolean;
  multiline?: boolean;
  style?: React.CSSProperties;
  variant?: "simple" | "outlined";
}

export interface CustomTextInputProps {
  type: TEXT_INPUT;
  hideLabel?: boolean;
  fullWidth?: boolean;
  helperText?: string;
  inputProps: FormInputCustomTextInputProps;
}
export interface CustomTimePickerInputProps {
  type: TIMEPICKER;
  hideLabel?: boolean;
  fullWidth?: boolean;
  inputProps: TimePickerComponent;
}
export interface CustomCodeInputProps {
  type: CODE_INPUT;
  hideLabel?: boolean;
  inputProps: Omit<OTPInputProps, "renderInput">;
}

export interface RadioGroupInputProps {
  flex?: boolean;
  type: RADIOS_GROUP;
  hideLabel?: boolean;
  fullWidth?: boolean;
  multiple?: boolean;
  radios: {
    checked?: boolean;
    value: string;
    minWidth?: string;
    label: string;
    shadowColor?: string;
    icon?: string | ReactSVGElement;
    onClick: (value: string) => any;
  }[];
}

export interface innerSelectorInputProps extends CustomSelectorProps {
  options: SelectOptionsProps[];
  value?: string;
  onClick: (value: string) => any;
}

export interface SelectorInputProps {
  type: SELECTOR;
  fullWidth?: boolean;
  width30percent?: boolean;
  hideLabel?: boolean;
  inputProps: CustomSelectorProps;
}

export interface CustomDatePickerProps {
  type: DATE_PICKER;
  hideLabel?: boolean;
  fullWidth?: boolean;
  inputProps: DateComponentProps;
}

export interface CustomRangeDatePickerProps {
  type: RANGE_DATE_PICKER;
  hideLabel?: boolean;
  fullWidth?: boolean;
  inputProps: {
    value: Date[];
    onChange: (val: Date, index: 0 | 1) => any;
  };
}

export interface SelectInputCompProps {
  type: SELECT_INPUT;
  fullWidth?: boolean;
  hideLabel?: boolean;
  select: CustomSelectorProps;
  input: TextInputProps;
}

export interface TitleAndSubtitleProps {
  type: TITLE_AND_SUBTITLE;
  texts: TitleAndSubtitleCompProps;
}

export interface MessageInCardProps {
  type: MESSAGE_IN_CARD;
  cardProps: MessageInCardCustomizableProps;
}

export interface DividerProps {
  type: DIVIDER;
  alignCenter?: boolean;
}

export interface IdentificationProps {
  type: IDENTIFICATION;
  onDelete: (id: string | number) => any;
  cardProps: IdentificationCompProps[];
}

export interface ChildrenProps {
  type: CHILDREN;
  fullWidth?: boolean;
  width30percent?: boolean;
  children: React.FC<any> | Element | any;
}

export interface MapProps {
  type: MAP;
  hideLabel?: boolean;
  mapProps: GoogleMapComponentProps;
}

export interface CustomDocumentPickerResponse {
  id: string;
  name: string;
  type: string;
  uri: string;
  date: Date;
}

export interface FileListAttacherInputProps {
  type: FILE_LIST_ATTACHER;
  maxFiles?: number;
  fullWidth?: boolean;
  hideLabel?: boolean;
  files: CustomDocumentPickerResponse[];
  bottomText?: string;
  setFiles?: (files: CustomDocumentPickerResponse[]) => void;
  deleteFile: (id: string) => void;
  mainButton?: MuiButtonProps;
  labelIcon?: React.ReactNode;
}

export interface PhotosAndBookCompProps {
  type: GALLERY;
  addFunc: () => any;
  pressAlbum: (id: string) => any;
  files: PhotosAndBookProps[];
}

export interface SwitchCompProps {
  type: SWITCH;
  formControlLabel: Omit<FormControlLabelProps, "control">;
  inputProps: SwitchProps;
}

export interface GalleryOpenProps {
  type: GALLERY_OPEN;
  back: () => any;
  addFunc: () => any;
  title: string;
  deletePhoto: (id: string) => any;
  switchPhoto?: (id: string) => any;
  files: PhotosProps[];
}

export interface ButtonProps {
  type: BUTTON;
  width30percent?: boolean;
  fullWidth?: boolean;
  label?: string;
  button: MuiButtonProps;
}

export interface AcceptAndCancelProps {
  type: ACCEPT_AND_CANCEL;
  fullWidth?: boolean;
  accept: CustomButtonProps;
  cancel: CustomButtonProps;
}

export type FormInputTypes =
  | TEXT_INPUT
  | RADIOS_GROUP
  | SELECTOR
  | FILE_LIST_ATTACHER
  | DATE_PICKER
  | RANGE_DATE_PICKER
  | SWITCH
  | TIMEPICKER
  | SELECT_INPUT
  | TEXT_INPUT
  | TITLE_AND_SUBTITLE
  | CHILDREN
  | BUTTON
  | MAP
  | GALLERY_OPEN
  | GALLERY
  | MESSAGE_IN_CARD
  | IDENTIFICATION
  | DIVIDER
  | ACCEPT_AND_CANCEL
  | TIMEPICKER
  | CODE_INPUT;

export type InputPropsTypes = TextInputProps;

export type FormInputVariations =
  | CustomTextInputProps
  | SelectorInputProps
  | FileListAttacherInputProps
  | RadioGroupInputProps
  | CustomDatePickerProps
  | CustomRangeDatePickerProps
  | CustomTimePickerInputProps
  | SelectInputCompProps
  | TitleAndSubtitleProps
  | MapProps
  | SwitchCompProps
  | ChildrenProps
  | ButtonProps
  | PhotosAndBookCompProps
  | MessageInCardProps
  | IdentificationProps
  | DividerProps
  | AcceptAndCancelProps
  | CustomCodeInputProps
  | GalleryOpenProps;
