/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable @typescript-eslint/no-explicit-any */
import { Formik, FormikProps, FormikValues } from "formik";
import React, { Ref, useEffect, useState } from "react";
import { FormInputVariations } from "../FormInput/types";
import FormInput from "../FormInput/FormInput";
import styles from "./styles/FormMaker.module.scss";
import { CircularProgress } from "@mui/material";
import useGetAppNotications from "@/hooks/useGetAppNotifications/useGetAppNotifications";
import { useTranslations } from "next-intl";
import { PRIMARY_COLOR } from "@/styles/constants";

export interface FormMakerProps<T extends FormikValues> {
  keys: string[] | (keyof T)[];
  requiredFields?: Record<keyof T, boolean>;
  innerRef?: Ref<any>;
  errorLabels?: (keyof T)[];
  initialState: T;
  showSpinner?: boolean;
  handleSubmit: (...args: any[]) => any;
  formSteps: (
    key: keyof T,
    formikMetadata: FormikProps<T>,
    t: any
  ) => Record<keyof T | string, FormInputVariations>;
  overrideLabels?: {
    label: string;
    override: string;
  }[];
}

const FormMaker = <T extends FormikValues>({
  keys,
  innerRef,
  requiredFields,
  initialState,
  errorLabels,
  handleSubmit,
  overrideLabels,
  showSpinner,
  formSteps,
}: FormMakerProps<T>): React.ReactElement => {
  const t = useTranslations();

  const [localErrors, setLocalErrors] = useState<(keyof T)[]>();

  const { showMessage } = useGetAppNotications();

  useEffect(() => {
    localErrors?.forEach((error) => {
      if (error && error?.toString()) {
        showMessage(t(error?.toString()), "error");
      }
    });
    setTimeout(() => {
      setLocalErrors(undefined);
    }, 1000);
  }, [localErrors]);

  useEffect(() => {
    setLocalErrors(errorLabels);
  }, [errorLabels]);

  return (
    <>
      {!showSpinner && (
        <Formik
          innerRef={innerRef}
          initialValues={initialState}
          onSubmit={handleSubmit}
        >
          {(formikProps: FormikProps<T>) => {
            return (
              <>
                {keys.map((key) => {
                  const fieldKey = key as keyof T;
                  const isRequired = requiredFields
                    ? requiredFields[fieldKey]
                    : false;

                  const label =
                    (overrideLabels &&
                      overrideLabels.find((d) => d.label === key)?.override) ??
                    fieldKey;

                  const variationConfig = formSteps(fieldKey, formikProps, t)[
                    fieldKey
                  ];

                  return (
                    <FormInput
                      key={fieldKey as string}
                      label={t(label as string)} // Usa `as string` para asegurar que `t` reciba un string
                      required={isRequired}
                      showError={errorLabels?.includes(key)}
                      variationConfig={variationConfig}
                    />
                  );
                })}
              </>
            );
          }}
        </Formik>
      )}
      {showSpinner && (
        <div className={styles.loading}>
          <CircularProgress style={{ color: PRIMARY_COLOR }} size={"50px"} />
        </div>
      )}
    </>
  );
};

export default FormMaker;
