/* eslint-disable @typescript-eslint/no-explicit-any */
import { FormikProps } from "formik";
import { GenerateWithAiFormData } from "../types";
import { FormInputVariations } from "../../FormInput/types";
import styles from "../styles/GenerateWithAiModal.module.scss";
import { AutoAwesomeOutlined } from "@mui/icons-material";

export const initialStateGenerateWithAiForm: GenerateWithAiFormData = {
  details: "",
};

export const keysGenerateWithAiForm = [
  "header1",
  "divider",
  "draft",
  "details",
  "note",
  "buttons",
];

export const GenerateWithAiFormInputs =
  (
    handleGenerate: (details: string) => any,
    loadingGenerate: boolean,
    draft: string
  ) =>
  (
    key: keyof GenerateWithAiFormData,
    formikMetadata: FormikProps<GenerateWithAiFormData>,
    t: any
  ): Record<keyof GenerateWithAiFormData | string, FormInputVariations> => {
    const { values, handleChange, submitForm } = formikMetadata;

    const inputs: Record<
      keyof GenerateWithAiFormData | string,
      FormInputVariations
    > = {
      header1: {
        type: "title_and_subtitle",
        texts: {
          title: t("generateIADescription"),
        },
      },
      divider: {
        type: "divider",
      },
      details: {
        type: "text",
        fullWidth: true,
        inputProps: {
          value: values.details as string,
          placeholder: t("moreDetailsString"),
          multiline: true,
          style: {
            minHeight: "188px",
            alignItems: "flex-start",
            paddingTop: "8px",
          },
          onChange: handleChange("details"),
        },
      },

      note: {
        type: "children",
        fullWidth: true,
        children: (
          <>
            <p className={styles.note}>{t("moreDetailsNote")}</p>
          </>
        ),
      },

      buttons: {
        type: "accept_and_cancel",
        accept: {
          onClick: submitForm,
          children: t("apply"),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          disabled: !draft,
          style: {
            padding: "0 20px",
            height: "50px",
            backgroundColor: !draft ? "#e7e7e7" : "#13A407",
            borderRadius: "100px",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            color: "#fff",
          },
        },
        cancel: {
          onClick: () => handleGenerate(values.details),
          children: t(loadingGenerate ? "generating" : "generate"),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          startIcon: <AutoAwesomeOutlined />,
          disabled: loadingGenerate,
          style: {
            padding: "0 20px",
            height: "50px",
            backgroundColor: "#E23052",
            borderRadius: "100px",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            color: "#fff",
          },
        },
      },
    };

    if (draft) {
      inputs.draft = {
        type: "children",
        fullWidth: true,
        children: (
          <>
            <p className={styles.label}>{t("onlyDescription")}</p>
            <p className={styles.text}>{draft}</p>
          </>
        ),
      };
    }

    return inputs;
  };
