/* eslint-disable @typescript-eslint/no-explicit-any */
import { GoogleMap, GoogleMapProps, Marker } from "@react-google-maps/api";
import React, { useEffect, useRef } from "react";

const center = {
  lat: Number(process.env.NEXT_PUBLIC_CDMX_LAT) || 19.4326, // Latitud de CDMX (default: 19.4326)
  lng: Number(process.env.NEXT_PUBLIC_CDMX_LNG) || -99.1332, // Longitud de CDMX (default: -99.1332)
};

export interface GoogleMapComponentProps extends GoogleMapProps {
  onChangePosition?: ({ lat, lng }: { lat: number; lng: number }) => any;
  marker?: { lat: number; lng: number };
}

const GoogleMapComponent: React.FC<GoogleMapComponentProps> = (props) => {
  const mapRef = useRef<google.maps.Map | null>(null);

  useEffect(() => {
    if (mapRef.current && props.center) {
      mapRef.current.panTo(props.center);
    }
  }, [props.center]);

  return (
    <>
      {process.env.NEXT_PUBLIC_GOOGLE_MAPS_API_KEY && (
        <>
          <GoogleMap
            {...props}
            mapContainerStyle={{
              height: "100%",
              width: "100%",
            }}
            center={props.center ?? center}
            zoom={12}
            onLoad={(map) => {
              mapRef.current = map;
            }}
            options={{
              // Solo deja los botones de zoom
              zoomControl: true,
              fullscreenControl: false,
              streetViewControl: false,
              mapTypeControl: false,
              scaleControl: false,
              rotateControl: false,
              clickableIcons: false,
              disableDefaultUI: true, // Esto desactiva todos los controles, pero igual podemos reactivar solo zoom
              gestureHandling: "greedy", // Permite arrastrar, hacer zoom con scroll y demás
            }}
            onCenterChanged={() => {
              if (props.onChangePosition) {
                props.onChangePosition({
                  lat: 0,
                  lng: 0,
                });
              }
            }}
          >
            {props.marker && props.marker.lat && props.marker.lng && (
              <Marker position={props.marker} />
            )}
          </GoogleMap>
        </>
      )}
    </>
  );
};

export default GoogleMapComponent;
