import React, { useState } from "react";
import Image from "next/image";
import styles from "./styles.module.scss";
import logo from "../../assets/icons/Logo.svg";
import { headerLinks } from "@/lib/routes";
import UserDropdown from "../UserDropdown/UserDropdown";
import { useTranslations } from "next-intl";
import { usePathname, useRouter } from "next/navigation";
import { PRIMARY_COLOR } from "@/styles/constants";
import LoginModal from "../LoginModal/LoginModal";
import useAuthentication from "@/hooks/useAuthentication/useAuthentication";
import { Close, Menu } from "@mui/icons-material";
import ResponsiveDrawer from "./components/ResponsiveDrawer/ResponsiveDrawer";

const Header: React.FC = () => {
  const t = useTranslations();

  const pathname = usePathname();

  const { user } = useAuthentication();

  const navigate = useRouter();

  const [openModal, setOpenModal] = useState<boolean>(false);

  const [drawer, setDrawer] = useState(false);

  const navigateTo = (link: string) => {
    navigate.push(link);
  };

  return (
    <div className={styles.container} style={{ zIndex: drawer ? 1201 : 1200 }}>
      <div className={styles.maxContainer}>
        <div className={styles.menuIcon} onClick={() => setDrawer(!drawer)}>
          {drawer ? (
            <Close
              htmlColor={"#7a7a7a"}
              sx={{ fontSize: "40px", marginLeft: "-7px" }}
            />
          ) : (
            <Menu
              htmlColor={"#7a7a7a"}
              sx={{ fontSize: "40px", marginLeft: "-7px" }}
            />
          )}
        </div>
        <Image src={logo} alt="Fieloo logo" />
        <div className={styles.routes}>
          {headerLinks.map((d) => {
            return (
              <p
                key={d.name}
                style={{
                  color:
                    pathname.replaceAll("/es", "/").replaceAll("/en", "/") ===
                    d.link
                      ? PRIMARY_COLOR
                      : "#000",
                }}
                className={styles.links}
                onClick={() => navigateTo(d.link)}
              >
                {t(d.name)}
              </p>
            );
          })}
          <UserDropdown onLogin={() => setOpenModal(!openModal)} />
        </div>
      </div>
      {!user && (
        <LoginModal
          modalProps={{ isOpen: openModal, toggle: () => setOpenModal(false) }}
        />
      )}
      <div
        style={{ zIndex: drawer ? 1201 : 1200 }}
        className={styles.gradient}
      ></div>
      <div className={styles.drawerContainer}>
        <ResponsiveDrawer
          open={drawer}
          onClose={() => setDrawer(!drawer)}
          onLogin={() => setOpenModal(!openModal)}
        />
      </div>
    </div>
  );
};

export default Header;
