/* eslint-disable @typescript-eslint/no-explicit-any */
import {
  Box,
  Divider,
  Drawer,
  ListItemIcon,
  ListItemText,
  MenuItem,
  MenuList,
} from "@mui/material";
import React from "react";
import styles from "./styles/ResponsiveDrawer.module.scss";
import { Login, Logout } from "@mui/icons-material";
import useAuthentication from "../../../../hooks/useAuthentication/useAuthentication";
import { useTranslations } from "next-intl";
import { AllRoutes } from "@/lib/routes";
import { useRouter } from "next/navigation";
import { PRIMARY_COLOR } from "@/styles/constants";

export interface ResponsiveDrawerProps {
  open: boolean;
  onClose: () => any;
  onLogin: () => any;
}

const ResponsiveDrawer: React.FC<ResponsiveDrawerProps> = ({
  open,
  onClose,
  onLogin,
}) => {
  const t = useTranslations();
  const { user, logout } = useAuthentication();
  const navigate = useRouter();

  const handleGotoMyProfile = () => {
    navigate.push(AllRoutes.UPDATE_PROFILE);
    onClose();
  };
  const handleGotoMyProperties = () => {
    navigate.push(AllRoutes.MY_PROPERTIES);
    onClose();
  };

  return (
    <Drawer style={{ width: "100%" }} open={open} onClose={onClose}>
      <Box sx={{ width: "100vw" }} role="presentation">
        <div className={styles.mainContainer}>
          <MenuList dense style={{ width: "100%" }}>
            {!user && (
              <>
                <MenuItem
                  onClick={() => {
                    onClose();
                    onLogin();
                  }}
                  style={{ color: PRIMARY_COLOR }}
                >
                  <ListItemIcon>
                    <Login color="primary" />
                  </ListItemIcon>
                  {t("login")}
                </MenuItem>
              </>
            )}
            {user && (
              <>
                <MenuItem onClick={handleGotoMyProfile}>
                  <ListItemText inset>{t("myProfile")}</ListItemText>
                </MenuItem>
                <MenuItem onClick={handleGotoMyProperties}>
                  <ListItemText inset>{t("myProperties")}</ListItemText>
                </MenuItem>
                <Divider />
                <MenuItem onClick={logout} sx={{ color: "red" }}>
                  <ListItemIcon>
                    <Logout sx={{ color: "red" }} />
                  </ListItemIcon>
                  {t("logout")}
                </MenuItem>
              </>
            )}
          </MenuList>
        </div>
      </Box>
    </Drawer>
  );
};

export default ResponsiveDrawer;
