"use client";
import { ReactNode, useMemo } from "react";
import styles from "./styles.module.scss";
import Header from "../Header/Header";
import Footer from "../Footer/Footer";
import { usePathname } from "next/navigation";
import { AllRoutes } from "@/lib/routes";
import { LoadScriptNext } from "@react-google-maps/api";

const HomeLayout = (props: { children: ReactNode }) => {
  const pathname = usePathname();

  const noPaddingViews = useMemo(() => {
    const realpathname = pathname.replace("/es", "").replace("/en", "") + "/";

    return (
      realpathname === AllRoutes.MAIN ||
      realpathname.includes(AllRoutes.PROPERTY)
    );
  }, [pathname]);

  return (
    <LoadScriptNext
      googleMapsApiKey={process.env.NEXT_PUBLIC_GOOGLE_MAPS_API_KEY as string}
      onError={(error) => {
        console.error("Error cargando la API de Google Maps:", error);
      }}
    >
      <div className={styles.pageContainer}>
        <Header />
        {noPaddingViews ? (
          <>{props.children}</>
        ) : (
          <div className={styles.content}>{props.children}</div>
        )}
        <Footer />
      </div>
    </LoadScriptNext>
  );
};

export default HomeLayout;
