/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useState } from "react";
import ModalMaker, { ModalMakerProps } from "../ModalMaker/ModalMaker";

import styles from "./styles/ImportModal.module.scss";
import { useTranslations } from "next-intl";
import TitleAndSubtitle from "../TitleAndSubtitle/TitleAndSubtitle";
import { PRIMARY_COLOR } from "@/styles/constants";
import { Button, Radio } from "@mui/material";
import Image from "next/image";
import easybroker from "@/assets/icons/easybroker.svg";
import excel from "@/assets/icons/excel.svg";
import EasyBrokerKeysCrud from "./components/EasyBrokerKeysCrud/EasyBrokerKeysCrud";
import ExcelImportation from "./components/ExcelImportation/ExcelImportation";

interface ImportModalProps {
  modalProps: ModalMakerProps;
  retryFunction: () => any;
}

const ImportModal: React.FC<ImportModalProps> = ({
  modalProps,
  retryFunction,
}) => {
  const t = useTranslations();

  const [option, setOption] = useState<"easybroker" | "excel" | "">("");

  const [step, setStep] = useState(0);

  return (
    <ModalMaker
      {...{
        ...modalProps,
        toggle: step > 0 ? () => setStep(step - 1) : modalProps.toggle,
      }}
      showToggle
      style={{
        maxWidth: "500px",
        width: "100%",
      }}
    >
      {step === 0 && (
        <div className={styles.importModalContainer}>
          <TitleAndSubtitle
            title={t("import")}
            showDivider
            style={{
              alignItems: "center",
            }}
            subtitleStyle={{
              marginTop: "20px",
              fontSize: "21px",
              color: "#414141",
              lineHeight: "31px",
              fontWeight: "600",
            }}
            subtitle={t("selectAnOption")}
          />
          <div className={styles.options}>
            <div
              className={styles.option}
              onClick={() => setOption("easybroker")}
            >
              <Image src={easybroker} alt="easybroker" />
              <p className={styles.text}>{t("easybroker")}</p>
              <Radio
                onClick={() => setOption("easybroker")}
                checked={option === "easybroker"}
              />
            </div>
            <div className={styles.option} onClick={() => setOption("excel")}>
              <Image src={excel} alt="excel" />
              <p className={styles.text}>{t("excelFile")}</p>
              <Radio
                onClick={() => setOption("excel")}
                checked={option === "excel"}
              />
            </div>
          </div>
          <Button
            {...{
              onClick: () => {
                if (option !== "") {
                  setStep(step + 1);
                }
              },
              children: t("next"),
              variant: "contained",
              color: "primary",
              disableElevation: true,
              style: {
                flex: 1,
                height: "50px",
                minWidth: "200px",
                backgroundColor: PRIMARY_COLOR,
                borderRadius: "100px",
                display: "flex",
                justifyContent: "center",
                alignItems: "center",
                color: "#fff",
              },
            }}
          ></Button>
        </div>
      )}
      {step === 1 && option === "easybroker" && (
        <div className={styles.importModalContainer}>
          <TitleAndSubtitle
            title={t("manageKeys")}
            showDivider
            style={{
              alignItems: "center",
            }}
            subtitleStyle={{
              marginTop: "20px",
              fontSize: "21px",
              color: "#414141",
              lineHeight: "31px",
              fontWeight: "600",
            }}
            subtitle={t("addKeysText")}
          />
          <EasyBrokerKeysCrud
            toggleGeneral={() => {
              modalProps.toggle();
              retryFunction();
            }}
          />
        </div>
      )}
      {step === 1 && option === "excel" && (
        <div className={styles.importModalContainer}>
          <TitleAndSubtitle
            title={t("importFromExcel")}
            showDivider
            style={{
              alignItems: "center",
            }}
            subtitleStyle={{
              marginTop: "20px",
              fontSize: "21px",
              color: "#414141",
              lineHeight: "31px",
              fontWeight: "600",
              maxWidth: "80%",
            }}
            subtitle={t("importYourProperties")}
          />
          <ExcelImportation onCancel={() => setStep(step - 1)} />
        </div>
      )}
    </ModalMaker>
  );
};

export default ImportModal;
