/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable react-hooks/exhaustive-deps */
import React, { useCallback, useEffect, useMemo, useState } from "react";
import styles from "./styles.module.scss";
import CrudMaker from "@/components/CrudMaker/CrudMaker";
import { KeyObject } from "./types";
import { columns } from "./constants/columns";
import { useTranslations } from "next-intl";
import { CircularProgress, useMediaQuery } from "@mui/material";
import { CustomButtonProps } from "@/components/FormInput/types";
import { TERCIARY_COLOR } from "@/styles/constants";
import { Add } from "@mui/icons-material";
import AddKeyModal from "./components/AddKeyModal/AddKeyModal";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  deleteKey,
  easybrokersIndex,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import {
  DeleteKeyParams,
  DeleteKeyResponse,
  EasyBrokersParams,
  EasyBrokersResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import { SearchObject } from "@/screens/Results/components/MoreFilters/moreFilters";
import { CurrentFormInputProps } from "@/components/FormInput/FormInput";
import SwalComponent from "@/components/SwalComponent/SwalComponent";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import ViewImportationsEasyBrokerModal from "./components/ViewImportationsEasyBrokerModal/ViewImportationsEasyBrokerModal";

interface EasyBrokerKeysCrudProps {
  toggleGeneral: () => any;
}

const EasyBrokerKeysCrud: React.FC<EasyBrokerKeysCrudProps> = ({
  toggleGeneral,
}) => {
  const t = useTranslations();

  const is_responsive = useMediaQuery("(max-width:700px)");

  const [addModalOpen, setAddModalOpen] = useState(false);
  const [propertiesImportModal, setPropertiesImportModal] = useState<
    string | null
  >(null);
  const [editMode, setEditMode] = useState<KeyObject | null>(null);

  const { clearAll, showAlert } = useRnSwal();

  const [filters, setFilters] = useState<SearchObject>({
    offset: 0,
    limit: 10,
  });

  const [data, setData] = useState<KeyObject[]>([]);

  const [totalpages, settotalpages] = useState(0);

  const { fetcher, requestStatus } = useRequestHandler<
    EasyBrokersResponse,
    EasyBrokersParams
  >(easybrokersIndex);
  const { fetcher: fetcherDelete } = useRequestHandler<
    DeleteKeyResponse,
    DeleteKeyParams
  >(deleteKey);

  const buttonsdata = useMemo(() => {
    const items: CustomButtonProps[] = [
      {
        onClick: () => setAddModalOpen(true),
        children: t("addKey"),
        variant: "outlined",
        maxWidth: is_responsive ? "100%" : "fit-content",
        color: "primary",
        startIcon: <Add />,
        style: {
          margin: "0 auto",
          height: "50px",
          backgroundColor: "#fff",
          border: "1px solid " + TERCIARY_COLOR,
          borderRadius: "7px",
          display: "flex",
          justifyContent: "center",
          padding: "0 30px",
          alignItems: "center",
          color: TERCIARY_COLOR,
        },
      },
    ];

    return items.filter((d) => !d.hidden);
  }, [is_responsive, t]);

  const retryFunction = useCallback(
    async (currentFilters?: Partial<SearchObject>) => {
      const payload = {
        offset: currentFilters?.offset ?? filters?.offset ?? 0,
        limit: currentFilters?.limit ?? filters?.limit ?? 10,
      };

      const query = await fetcher(payload);

      if (query.status === "success") {
        setData(query.response.easybrokers);
        settotalpages(query.response.total);
      }
    },
    [fetcher, filters?.limit, filters?.offset]
  );

  const filtersdata = useMemo(() => {
    const items: CurrentFormInputProps[] = [
      {
        required: false,
        minWidth: "100%",
        variationConfig: {
          type: "children",
          children: (
            <>
              <div
                className={styles.master}
                style={{
                  width: "100%",
                  display: "flex",
                  flexDirection: "row",
                  justifyContent: is_responsive ? "center" : "flex-end",
                }}
              >
                {!!requestStatus.loading && (
                  <CircularProgress style={{ color: "#000" }} size={"15px"} />
                )}
              </div>
            </>
          ),
        },
      },
    ];
    return items;
  }, [is_responsive, requestStatus]);

  useEffect(() => {
    retryFunction();
  }, []);

  const handleproperties = useCallback(
    (id: string) => {
      setPropertiesImportModal(propertiesImportModal ? null : id);
    },
    [propertiesImportModal]
  );

  const handleedit = useCallback(
    (key: KeyObject | null) => {
      setAddModalOpen(!addModalOpen);
      setEditMode(editMode ? null : key);
    },
    [editMode, addModalOpen]
  );

  const handledelete = useCallback(
    (id: string) => {
      const trigger = async () => {
        const query = await fetcherDelete({
          id,
        });

        if (query.status === "success") {
          showAlert(
            "success",
            t("deletedSuccessfully"),
            undefined,
            undefined,
            undefined,
            () => {
              clearAll();
              retryFunction(filters);
            }
          );
        }
      };

      showAlert(
        "accept_or_deny",
        t("areYouSureToDeleteThisKey"),
        undefined,
        undefined,
        undefined,
        trigger,
        () => {
          clearAll();
        }
      );
    },
    [filters]
  );

  return (
    <div className={styles.container}>
      <CrudMaker<KeyObject>
        data={data}
        columns={columns(t, handleproperties, handleedit, handledelete, data)}
        buttons={buttonsdata}
        filters={filtersdata}
        title={""}
        tableName={""}
        page={(filters?.offset ?? 0) + 1}
        pageSize={filters?.limit}
        totalPages={totalpages}
        setPageSize={(val: number) => {
          const payload = {
            ...filters,
            limit: val,
            offset: 0,
          };
          setFilters(payload);
          retryFunction(payload);
        }}
        setPage={(val: number) => {
          const payload = {
            ...filters,
            offset: val - 1,
          };
          setFilters(payload);
          retryFunction(payload);
        }}
      />
      {addModalOpen && (
        <AddKeyModal
          modalProps={{
            isOpen: addModalOpen,
            toggle: () => handleedit(null),
          }}
          editMode={editMode}
          retryFunction={retryFunction}
        />
      )}
      {propertiesImportModal && (
        <ViewImportationsEasyBrokerModal
          modalProps={{
            isOpen: !!propertiesImportModal,
            toggle: () => handleproperties(""),
          }}
          id={propertiesImportModal}
          toggleGeneral={toggleGeneral}
        />
      )}
      <SwalComponent />
    </div>
  );
};

export default EasyBrokerKeysCrud;
