import React, { useRef, useState } from "react";
import styles from "./styles/AddKeyModal.module.scss";
import { AddKeyFormData } from "./types";
import {
  AddKeyFormInputs,
  initialStateAddKeyForm,
  keysAddKeyForm,
} from "./forms/formInputs";
import { FormikProps } from "formik";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  AddKeyParams,
  AddKeyResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import { addKey } from "@/lib/services/redux/reducers/properties/propertiesActions";
import ModalMaker, {
  ModalMakerProps,
} from "@/components/ModalMaker/ModalMaker";
import FormMaker from "@/components/FormMaker/FormMaker";
import { KeyObject } from "../../types";

interface AddKeyModalProps {
  modalProps: ModalMakerProps;
  retryFunction: () => unknown;
  editMode: KeyObject | null;
}

const AddKeyModal: React.FC<AddKeyModalProps> = ({
  modalProps,
  retryFunction,
  editMode,
}) => {
  const formikRef = useRef<FormikProps<AddKeyFormData>>(null);

  const [formErrors] = useState<(keyof AddKeyFormData)[]>([]);

  const { fetcher, requestStatus } = useRequestHandler<
    AddKeyResponse,
    AddKeyParams
  >(addKey);

  const handleSubmit = async (values: AddKeyFormData) => {
    const resp = await fetcher(values);

    if (resp.status === "success") {
      retryFunction();
      modalProps.toggle();
    }
  };

  return (
    <ModalMaker
      {...modalProps}
      showToggle
      style={{
        maxWidth: "500px",
        width: "100%",
      }}
    >
      <div className={styles.modalcontainer}>
        <FormMaker<AddKeyFormData>
          keys={keysAddKeyForm}
          initialState={initialStateAddKeyForm(editMode ? editMode : undefined)}
          handleSubmit={handleSubmit}
          innerRef={formikRef}
          errorLabels={formErrors}
          formSteps={AddKeyFormInputs(!!editMode, requestStatus.loading)}
        />
      </div>
    </ModalMaker>
  );
};

export default AddKeyModal;
