/* eslint-disable @typescript-eslint/no-explicit-any */
import { FormikProps } from "formik";
import { AddKeyFormData } from "../types";
import { FormInputVariations } from "@/components/FormInput/types";
import { PRIMARY_COLOR } from "@/styles/constants";
import { KeyObject } from "../../../types";

export const initialStateAddKeyForm = (
  initialData?: KeyObject
): AddKeyFormData => {
  return {
    key: initialData?.key ? initialData?.key : "",
    name: initialData?.name ? initialData?.name : "",
  };
};

export const keysAddKeyForm = [
  "header1",
  "divider",
  "name",
  "key",
  "note",
  "buttons",
];

export const AddKeyFormInputs =
  (editMode: boolean, loading: boolean) =>
  (
    key: keyof AddKeyFormData,
    formikMetadata: FormikProps<AddKeyFormData>,
    t: any
  ): Record<keyof AddKeyFormData | string, FormInputVariations> => {
    const { values, handleChange, submitForm } = formikMetadata;

    const inputs: Record<keyof AddKeyFormData | string, FormInputVariations> = {
      header1: {
        type: "title_and_subtitle",
        texts: {
          title: t(editMode ? "editKey" : "addKey"),
        },
      },
      divider: {
        type: "divider",
      },
      name: {
        type: "text",
        inputProps: {
          value: values?.[key] as string,
          placeholder: t("enter" + key),
          multiline: true,
          onChange: handleChange(key),
        },
      },
      key: {
        type: "text",
        inputProps: {
          value: values?.[key] as string,
          placeholder: t("enter" + key),
          multiline: true,
          onChange: handleChange(key),
        },
      },

      buttons: {
        type: "button",
        fullWidth: true,
        button: {
          onClick: submitForm,
          children: t(editMode ? "updateKey" : "add"),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          loading,
          disabled: loading,
          style: {
            padding: "0 40px",
            height: "50px",
            backgroundColor: PRIMARY_COLOR,
            borderRadius: "100px",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            color: "#fff",
          },
        },
      },
    };

    return inputs;
  };
