/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable react-hooks/exhaustive-deps */
import React, { useCallback, useEffect, useMemo, useState } from "react";
import styles from "./styles.module.scss";
import CrudMaker from "@/components/CrudMaker/CrudMaker";
import { useTranslations } from "next-intl";
import { CircularProgress, useMediaQuery } from "@mui/material";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  easybrokersIndexProperties,
  getPropertyComplete,
  importProperty,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import {
  EasyBrokersPropertiesParams,
  EasyBrokersPropertiesResponse,
  getPropertyCompleteParams,
  getPropertyCompleteResponse,
  ImportPropertyParams,
  ImportPropertyResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import FormInput, {
  CurrentFormInputProps,
} from "@/components/FormInput/FormInput";
import SwalComponent from "@/components/SwalComponent/SwalComponent";
import { PropertyFromEasyBroker } from "./types";
import { columns } from "./constants/constants";
import ModalMaker, {
  ModalMakerProps,
} from "@/components/ModalMaker/ModalMaker";
import TitleAndSubtitle from "@/components/TitleAndSubtitle/TitleAndSubtitle";
import { SelectAll } from "@mui/icons-material";
import { PRIMARY_COLOR, TERCIARY_COLOR } from "@/styles/constants";
import { CustomButtonProps } from "@/components/FormInput/types";
import EditEasyBrokerPropertyModal from "./components/EditEasyBrokerPropertyModal/EditEasyBrokerPropertyModal";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import useGetAppNotications from "@/hooks/useGetAppNotifications/useGetAppNotifications";

interface CurrentSearchParams {
  page: number;
}

interface ViewImportationsEasyBrokerModalProps {
  modalProps: ModalMakerProps;
  id: string;
  toggleGeneral: () => any;
}

const ViewImportationsEasyBrokerModal: React.FC<
  ViewImportationsEasyBrokerModalProps
> = ({ modalProps, id, toggleGeneral }) => {
  const t = useTranslations();

  const is_responsive = useMediaQuery("(max-width:700px)");

  const { showMessage } = useGetAppNotications();

  const { fetcher: fetcherimport, requestStatus: requestStatusimport } =
    useRequestHandler<ImportPropertyResponse, ImportPropertyParams>(
      importProperty
    );
  const {
    fetcher: fetchergetProperty,
    requestStatus: requestStatusgetProperty,
  } = useRequestHandler<getPropertyCompleteResponse, getPropertyCompleteParams>(
    getPropertyComplete
  );

  const [addModalOpen, setAddModalOpen] = useState(false);
  const [editMode, setEditMode] = useState<PropertyFromEasyBroker | null>(null);

  // const { clearAll, showAlert } = useRnSwal();

  const [filters, setFilters] = useState<CurrentSearchParams>({
    page: 1,
  });

  const [data, setData] = useState<PropertyFromEasyBroker[]>([]);
  const [allids, setallids] = useState<string[]>([]);

  const [selected, setSelected] = useState<string[]>([]);
  const [selectAll, setSelectAll] = useState(false);

  const { clearAll, showAlert } = useRnSwal();

  const [totalpages, settotalpages] = useState(0);

  const { fetcher, requestStatus } = useRequestHandler<
    EasyBrokersPropertiesResponse,
    EasyBrokersPropertiesParams
  >(easybrokersIndexProperties);

  const handleSelectall = () => {
    if (selectAll) setSelected([]);
    setSelectAll(!selectAll);
  };

  const buttonsdata = useMemo(() => {
    const items: CustomButtonProps[] = [
      {
        onClick: handleSelectall,
        children: t("selectAll"),
        variant: "outlined",
        maxWidth: is_responsive ? "100%" : "fit-content",
        color: "primary",
        startIcon: <SelectAll />,
        style: {
          margin: "0 auto",
          height: "50px",
          backgroundColor: "#fff",
          border: "1px solid " + TERCIARY_COLOR,
          borderRadius: "7px",
          display: "flex",
          justifyContent: "center",
          padding: "0 30px",
          alignItems: "center",
          color: TERCIARY_COLOR,
        },
      },
    ];

    return items.filter((d) => !d.hidden);
  }, [is_responsive, selectAll, t]);

  const retryFunction = useCallback(
    async (currentFilters?: Partial<CurrentSearchParams>) => {
      const payload = {
        id,
        page: currentFilters?.page ?? filters?.page ?? 0,
      };

      const query = await fetcher(payload);

      if (query.status === "success") {
        setData(query.response.properties);
        setallids(query.response.allIds);
        settotalpages(query.response.total);
      }
    },
    [fetcher, filters?.page, id]
  );

  const filtersdata = useMemo(() => {
    const items: CurrentFormInputProps[] = [
      {
        required: false,
        minWidth: "100%",
        variationConfig: {
          type: "children",
          children: (
            <>
              <div
                className={styles.master}
                style={{
                  width: "100%",
                  display: "flex",
                  flexDirection: "row",
                  justifyContent: is_responsive ? "center" : "flex-end",
                }}
              >
                {!!requestStatus.loading && (
                  <CircularProgress style={{ color: "#000" }} size={"15px"} />
                )}
              </div>
            </>
          ),
        },
      },
    ];
    return items;
  }, [is_responsive, requestStatus]);

  useEffect(() => {
    retryFunction();
  }, []);

  const handleedit = useCallback(
    (key: PropertyFromEasyBroker | null) => {
      setAddModalOpen(!addModalOpen);
      console.log(key);
      setEditMode(editMode ? null : key);
    },
    [editMode, addModalOpen]
  );

  const handleSelectSome = useCallback(
    (id: string) => {
      if (selectAll) {
        setSelectAll(false);
        setSelected(allids.filter((d) => d !== id));
      } else {
        if (selected.includes(id))
          setSelected(selected.filter((d) => d !== id));
        else setSelected([...selected].concat(id));
      }
    },
    [selectAll, selected, data]
  );

  const handleSubmit = useCallback(async () => {
    const success = [];

    if (!selectAll && selected.length > 0) {
      const keys = [...selected];

      for await (const key of keys) {
        const query1 = await fetchergetProperty({
          type: "easybroker",
          data: key,
        });

        if (query1.status === "success") {
          const query2 = await fetcherimport({
            type: "easybroker",
            selection: key,
            dataId: id,
          });

          if (query2.status === "success") {
            success.push(query2.response.properties);
          }
        } else {
          retryFunction(filters);
          if (success.length > 0) {
            showMessage(success.length + " " + t("propertiesImported"), "info");
          }
          break;
        }
      }

      if (success.length === selected.length) {
        showAlert(
          "success",
          t("propertiesImportedSuccessfully"),
          undefined,
          undefined,
          undefined,
          () => {
            clearAll();
            modalProps.toggle();
            toggleGeneral();
          }
        );
        showMessage(success.length + " " + t("propertiesImported"), "success");
      }
    }
    if (selectAll && allids.length > 0) {
      const keys = [...allids];

      for await (const key of keys) {
        const query1 = await fetchergetProperty({
          type: "easybroker",
          data: key,
        });

        if (query1.status === "success") {
          const query2 = await fetcherimport({
            type: "easybroker",
            selection: key,
            dataId: id,
          });

          if (query2.status === "success") {
            success.push(query2.response.properties);
          }
        } else {
          retryFunction(filters);
          if (success.length > 0) {
            showMessage(success.length + " " + t("propertiesImported"), "info");
          }
          break;
        }
      }

      if (success.length === allids.length) {
        showAlert(
          "success",
          t("propertiesImportedSuccessfully"),
          undefined,
          undefined,
          undefined,
          () => {
            clearAll();
            modalProps.toggle();
            toggleGeneral();
          }
        );
        showMessage(success.length + " " + t("propertiesImported"), "success");
      }
    }
  }, [selectAll, selected, filters, allids]);

  return (
    <ModalMaker
      {...{
        ...modalProps,
        toggle: modalProps.toggle,
      }}
      showToggle
      style={{
        maxWidth: "750px",
        width: "100%",
      }}
    >
      <div className={styles.container}>
        <TitleAndSubtitle
          title={t("property")}
          showDivider
          style={{
            alignItems: "center",
          }}
          subtitleStyle={{
            marginTop: "20px",
            fontSize: "16px",
            color: "#414141",
            lineHeight: "25px",
            fontWeight: "600",
            textAlign: "left",
          }}
          subtitle={t("importingPropertiesText")}
        />
        <CrudMaker<PropertyFromEasyBroker>
          data={data}
          columns={columns(
            t,
            handleedit,
            handleSelectSome,
            data,
            selectAll ? data?.map((d) => d.public_id) : selected
          )}
          filters={filtersdata}
          title={""}
          tableName={""}
          buttons={buttonsdata}
          page={filters?.page ?? 1}
          pageSize={10}
          totalPages={totalpages}
          setPage={(val: number) => {
            const payload = {
              ...filters,
              page: val,
            };
            setFilters(payload);
            retryFunction(payload);
          }}
        />
        <FormInput
          required={false}
          variationConfig={{
            type: "button",
            fullWidth: true,
            button: {
              onClick: handleSubmit,
              children: t("upload"),
              variant: "contained",
              color: "primary",
              disableElevation: true,
              loading:
                requestStatusgetProperty?.loading ||
                requestStatusimport?.loading,
              disabled:
                !(selectAll || selected?.length) ||
                requestStatusgetProperty?.loading ||
                requestStatusimport?.loading ||
                requestStatus.loading,
              style: {
                padding: "0 40px",
                height: "50px",
                backgroundColor: !(selectAll || selected?.length)
                  ? "#7a7a7a"
                  : PRIMARY_COLOR,
                borderRadius: "100px",
                display: "flex",
                justifyContent: "center",
                alignItems: "center",
                color: "#fff",
              },
            },
          }}
        />
        {addModalOpen && editMode?.public_id && (
          <EditEasyBrokerPropertyModal
            modalProps={{
              isOpen: addModalOpen,
              toggle: () => handleedit(null),
            }}
            retryFunction={retryFunction}
            id={editMode?.public_id}
            apiKey={id}
            isComplete={editMode?.isComplete}
          />
        )}
        <SwalComponent />
      </div>
    </ModalMaker>
  );
};

export default ViewImportationsEasyBrokerModal;
