/* eslint-disable react-hooks/exhaustive-deps */
import React, { useCallback, useEffect, useState } from "react";
import styles from "./styles/EditEasyBrokerPropertyModal.module.scss";
import ModalMaker, {
  ModalMakerProps,
} from "@/components/ModalMaker/ModalMaker";
import { createPropertyFormData } from "@/components/CreatePropertyForm/types";
import TitleAndSubtitle from "@/components/TitleAndSubtitle/TitleAndSubtitle";
import { useTranslations } from "next-intl";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  CreatePropertyFromEasyBrokerParams,
  CreatePropertyFromEasyBrokerResponse,
  GetPropertyFromEasyBrokerParams,
  GetPropertyFromEasyBrokerResponse,
  UpdatePropertyFromEasyBrokerParams,
  UpdatePropertyFromEasyBrokerResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import {
  createPropertyFromEasyBroker,
  getPropertyFromEasyBroker,
  updatePropertyFromEasyBroker,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import { CircularProgress } from "@mui/material";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import ImportPropertyForm from "@/components/ImportPropertyForm/ImportPropertyForm";

interface EditEasyBrokerPropertyModalProps {
  modalProps: ModalMakerProps;
  retryFunction: () => unknown;
  id: string;
  apiKey: string;
  isComplete?: boolean;
}

const EditEasyBrokerPropertyModal: React.FC<
  EditEasyBrokerPropertyModalProps
> = ({ modalProps, apiKey, id, retryFunction, isComplete }) => {
  const t = useTranslations();

  const [data, setData] = useState<PropertyFromEasyBrokertFull>();

  const { fetcher, requestStatus } = useRequestHandler<
    GetPropertyFromEasyBrokerResponse,
    GetPropertyFromEasyBrokerParams
  >(getPropertyFromEasyBroker);
  const { fetcher: fetcherUpdate, requestStatus: requestStatusUpdate } =
    useRequestHandler<
      UpdatePropertyFromEasyBrokerResponse,
      UpdatePropertyFromEasyBrokerParams
    >(updatePropertyFromEasyBroker);
  const { fetcher: fetcherCreate, requestStatus: requestStatusCreate } =
    useRequestHandler<
      CreatePropertyFromEasyBrokerResponse,
      CreatePropertyFromEasyBrokerParams
    >(createPropertyFromEasyBroker);

  const { clearAll, showAlert } = useRnSwal();

  const handleSubmit = useCallback(
    async (values: createPropertyFormData) => {
      if (values) {
        const payload: Omit<UpdatePropertyFromEasyBrokerParams, "context"> = {
          apiKey: data?.id ?? "",
          type: "easybroker",
          data: id,
          categoryId: values.operationType,
          typeId: values.propertyType,
          setId: values.complex,
          price: values.price,
          m2Build: values.builtArea ?? 0,
          m2Property: values.landArea ?? 0,
          isWater: values.hasWater ? 1 : 0,
          isLight: values.hasElectricity ? 1 : 0,
          isGas: values.hasGas ? 1 : 0,
          isWifi: values.hasInternet ? 1 : 0,
          isPrivateSecurity: values.privateSecurity ? 1 : 0,
          isSchool: values.nearbySchools ? 1 : 0,
          isMaintenance: values.maintenanceIncluded ? 1 : 0,
          isSwimmingPool: values.hasPool ? 1 : 0,
          isAa: values.aa ? 1 : 0,
          isVideoSurveillance: values.hasSecurityCameras ? 1 : 0,
          isDisabled: values.accessibleForDisabled ? 1 : 0,
          isBeds: values.beds ? 1 : 0,
          isFurnished: values.furnished ? 1 : 0,
          isCloset: values.closet ? 1 : 0,
          isDryingMachine: values.driyingmachine ? 1 : 0,
          isLivingRoom: values.livingroom ? 1 : 0,
          isDiningRoom: values.diningroom ? 1 : 0,
          isOven: values.oven ? 1 : 0,
          isKitchen: values.kitchen ? 1 : 0,
          isRefrigerator: values.refrigerator ? 1 : 0,
          isStove: values.stove ? 1 : 0,
          isMicrowave: values.microwave ? 1 : 0,
          isMiniOven: values.oven ? 1 : 0,
          isWashingMachine: values.washingmachine ? 1 : 0,
          alias: values?.identifier,
          antiquity: values?.age?.toString() ?? "0",
          others: values?.others ?? "",
        };

        const query = await (!isComplete ? fetcherCreate : fetcherUpdate)(
          payload
        );

        if (query.status === "success") {
          retryFunction();
          showAlert(
            "success",
            t(!isComplete ? "createdSuccessfully" : "updatedSuccessfully"),
            undefined,
            undefined,
            undefined,
            () => {
              clearAll();
              modalProps.toggle();
            }
          );
        }
      }
    },
    [isComplete, data?.id]
  );
  const retryFunctionHere = async () => {
    const query = await fetcher({
      id: apiKey,
      public_id: id,
    });

    if (query.status === "success") {
      setData(query?.response.properties?.[0]);
    }
  };

  useEffect(() => {
    retryFunctionHere();
  }, []);

  return (
    <ModalMaker
      {...modalProps}
      showToggle
      style={{
        maxWidth: "900px",
        width: "100%",
      }}
    >
      <div className={styles.modalcontainer}>
        <TitleAndSubtitle
          title={t("easyBrokerProperty")}
          showDivider
          style={{
            alignItems: "center",
          }}
          subtitleStyle={{
            marginTop: "20px",
            fontSize: "16px",
            color: "#414141",
            lineHeight: "25px",
            fontWeight: "600",
            textAlign: "left",
            marginBottom: "20px",
          }}
          subtitle={t("easyBrokerPropertyText")}
        />
        {requestStatus?.loading && (
          <div className={styles.loader}>
            <CircularProgress color="primary" />
          </div>
        )}
        {data && (
          <ImportPropertyForm
            easyBrokerData={data}
            handleSubmit={handleSubmit}
            loading={requestStatusUpdate.loading || requestStatusCreate.loading}
          />
        )}
      </div>
    </ModalMaker>
  );
};

export default EditEasyBrokerPropertyModal;
