/* eslint-disable @typescript-eslint/no-explicit-any */
type LocationHere = {
  name: string;
  latitude: number;
  longitude: number;
  street: string | null;
  postal_code: string | null;
  show_exact_location: boolean;
  hide_exact_location: boolean;
  exterior_number: string | null;
  interior_number: string | null;
};

type Commission = {
  type: string;
  value: string | number;
};

type Operation = {
  type: string;
  amount: number;
  currency: string;
  formatted_amount: string;
  commission: Commission;
  unit: string;
};

type Image = {
  title: string | null;
  url: string;
};

type Agent = {
  id: number;
  name: string;
  full_name: string;
  mobile_phone: string;
  profile_image_url: string;
  email: string;
};

type PropertyFromEasyBrokertFull = {
  public_id: string;
  title: string;
  description: string;
  bedrooms: number | null;
  bathrooms: number | null;
  half_bathrooms: number | null;
  parking_spaces: number;
  lot_size: number;
  construction_size: number;
  lot_length: number;
  lot_width: number;
  floors: number;
  floor: number | null;
  age: number;
  internal_id: string;
  expenses: string;
  location: LocationHere;
  property_type: string;
  created_at: string;
  updated_at: string;
  published_at: string;
  operations: Operation[];
  property_files: any[]; // No hay estructura definida
  videos: any[];
  virtual_tour: string | null;
  collaboration_notes: string | null;
  public_url: string;
  shared_commission_percentage: number | null;
  exclusive: boolean | null;
  tags: string[];
  private_description: string | null;
  show_prices: boolean;
  share_commission: boolean;
  property_images: Image[];
  images: Image[];
  agent: Agent;
  features: string[];
  price: number;
  commision: number;
  sets: string;
  alias: string | null;
  total: number;
  antiquity: number | null;
  m2build: number;
  m2land: number;
  isWatter: boolean;
  isLight: boolean;
  isGas: boolean;
  isWifi: boolean;
  isSecurity: boolean;
  isSchool: boolean;
  isMaintenance: boolean;
  isPool: boolean;
  isCamera: boolean;
  isDisabled: boolean;
  isFurnished: boolean;
  isBed: boolean;
  isCloset: boolean;
  isHall: boolean;
  isDiningRoom: boolean;
  isKitchen: boolean;
  isAA: boolean;
  isFridge: boolean;
  isStove: boolean;
  isMicrowave: boolean;
  isMiniOven: boolean;
  isOven: boolean;
  isWashingMachine: boolean;
  isDryer: boolean;
  other: string | null;
  category: string;
  propertyType: string;
  id: string;
};
