/* eslint-disable @next/next/no-img-element */
import { Column } from "@/components/DynamicTable/DynamicTable";
import { Checkbox, IconButton } from "@mui/material";
import { EditNoteRounded, StarRounded } from "@mui/icons-material";
import styles from "../styles.module.scss";
import { PropertyFromEasyBroker } from "../types";

/* eslint-disable @typescript-eslint/no-explicit-any */
export const columns = (
  t: any,
  handleedit: (key: PropertyFromEasyBroker) => any,
  handleSelectSome: (id: string) => any,
  data: PropertyFromEasyBroker[],
  selected: string[]
): Column<PropertyFromEasyBroker>[] => {
  return [
    {
      id: "property",
      label: "property",
      render: (item: PropertyFromEasyBroker) => {
        return (
          <div className={styles.propertyRow}>
            <img
              className={styles.img}
              src={item.title_image_full}
              alt="image"
            />
            <p>{item.title}</p>
          </div>
        );
      },
    },

    {
      id: "actions",
      label: "actions",
      render: (item: PropertyFromEasyBroker) => {
        return (
          <div className={styles.iconButtons}>
            <IconButton
              onClick={() => {
                const found = data.find((d) => d.public_id === item?.public_id);
                if (found) handleedit(found);
              }}
            >
              <EditNoteRounded htmlColor="green" />
            </IconButton>
            <Checkbox
              onClick={() => {
                handleSelectSome(item.public_id);
              }}
              checked={selected.includes(item.public_id)}
            />
            {item?.isComplete && <StarRounded htmlColor="orange" />}
          </div>
        );
      },
    },
  ];
};
