import { Column } from "@/components/DynamicTable/DynamicTable";
import { KeyObject } from "../types";
import { IconButton } from "@mui/material";
import {
  DeleteRounded,
  EditNoteRounded,
  HouseRounded,
} from "@mui/icons-material";
import styles from "../styles.module.scss";

/* eslint-disable @typescript-eslint/no-explicit-any */
export const columns = (
  t: any,
  handleproperties: (id: string) => any,
  handleedit: (key: KeyObject) => any,
  handledelete: (id: string) => any,
  data: KeyObject[]
): Column<KeyObject>[] => {
  return [
    {
      id: "name",
      label: "name",
    },
    {
      id: "used",
      label: "used",
      render: (item: KeyObject) => {
        return <>{t(item?.status ? "yes" : "no")}</>;
      },
    },
    {
      id: "actions",
      label: "actions",
      render: (item: KeyObject) => {
        return (
          <div className={styles.iconButtons}>
            <IconButton onClick={() => handleproperties(item?.id)}>
              <HouseRounded htmlColor="orange" />
            </IconButton>
            <IconButton
              onClick={() => {
                const found = data.find((d) => d.id === item?.id);
                if (found) handleedit(found);
              }}
            >
              <EditNoteRounded htmlColor="green" />
            </IconButton>
            <IconButton onClick={() => handledelete(item?.id)}>
              <DeleteRounded htmlColor="red" />
            </IconButton>
          </div>
        );
      },
    },
  ];
};
