/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable @typescript-eslint/no-explicit-any */
import Image from "next/image";
import React, { useCallback, useRef, useState } from "react";
import styles from "../../styles/ImportModal.module.scss";
import { Button } from "@mui/material";
import xlsxIcon from "@/assets/icons/xlsxIcon.svg";
import zipIcon from "@/assets/icons/zipIcon.svg";
import { Close, UploadFile } from "@mui/icons-material";
import { useTranslations } from "next-intl";
import FormInput from "@/components/FormInput/FormInput";
import { PRIMARY_COLOR } from "@/styles/constants";
import {
  handleExcels,
  importProperty,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import {
  HandleExcelsParams,
  HandleExcelsResponse,
  ImportPropertyParams,
  ImportPropertyResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import createId from "@/lib/utils/create-id";
import { CustomDocumentPickerResponse } from "@/components/FormInput/types";
import useRnSwal from "@/hooks/useRnSwal/useRnSwal";
import useGetAppNotications from "@/hooks/useGetAppNotifications/useGetAppNotifications";

interface ExcelImportationProps {
  onCancel: () => any;
}

const ExcelImportation: React.FC<ExcelImportationProps> = ({ onCancel }) => {
  const t = useTranslations();

  const { fetcher: fetcherExcels, requestStatus: requestStatusExcels } =
    useRequestHandler<HandleExcelsResponse, HandleExcelsParams>(handleExcels);

  const { fetcher: fetcherimport, requestStatus: requestStatusimport } =
    useRequestHandler<ImportPropertyResponse, ImportPropertyParams>(
      importProperty
    );

  const { showMessage } = useGetAppNotications();

  const { clearAll, showAlert } = useRnSwal();

  const [excelFile, setExcelFile] = useState<CustomDocumentPickerResponse>();
  const [zipFile, setZipFile] = useState<CustomDocumentPickerResponse>();

  const fileInputRef1 = useRef<HTMLInputElement>(null);
  const fileInputRef2 = useRef<HTMLInputElement>(null);

  const handleFileSelection = async (
    event: React.ChangeEvent<HTMLInputElement>,
    type: "excel" | "zip"
  ) => {
    const file = event.target.files?.[0];

    if (file && event.target.files && event.target.files?.length > 0) {
      if (type === "excel")
        setExcelFile({
          id: createId(),
          name: file.name,
          type: file.type,
          uri: URL.createObjectURL(file),
          date: new Date(),
        });
      else
        setZipFile({
          id: createId(),
          name: file.name,
          type: file.type,
          uri: URL.createObjectURL(file),
          date: new Date(),
        });
    }
  };

  const handleSubmit = useCallback(async () => {
    if (excelFile) {
      const query = await fetcherExcels({
        excel: excelFile,
        zip: zipFile,
      });

      const success = [];

      if (
        query.status === "success" &&
        query.response.array &&
        query.response.array.length
      ) {
        const keys = query.response.array;

        for await (const k of keys) {
          const query2 = await fetcherimport({
            type: "excel",
            selection: k,
          });

          if (query2.status === "success") {
            success.push(query2.response.properties);
          }
        }

        if (success.length === keys.length) {
          showAlert(
            "success",
            t("propertiesImportedSuccessfully"),
            undefined,
            undefined,
            undefined,
            () => {
              clearAll();
            }
          );
          showMessage(
            success.length + " " + t("propertiesImported"),
            "success"
          );
        }
      } else {
        showMessage(t("noValidPropertiesFound"), "error");
      }
    }
  }, [excelFile, zipFile]);

  return (
    <>
      <p className={styles.descriptions}>{t("excelDescriptions")}</p>
      <div
        className={styles.options}
        style={{ gap: "15px", height: "fit-content", padding: "20px 0" }}
      >
        <div className={styles.option}>
          <Image src={xlsxIcon} alt="xlsxIcon" />
          {!excelFile && (
            <Button
              {...{
                onClick: () => fileInputRef1.current?.click(),
                children: t("uploadExcel"),
                variant: "contained",
                color: "primary",
                startIcon: <UploadFile />,
                disableElevation: true,
                style: {
                  flex: 1,
                  height: "50px",
                  width: "100%",
                  backgroundColor: "#1D6F42",
                  borderRadius: "7px",
                  display: "flex",
                  justifyContent: "center",
                  alignItems: "center",
                  color: "#fff",
                },
              }}
            ></Button>
          )}
          {excelFile && (
            <Button
              {...{
                onClick: () => setExcelFile(undefined),
                children: t("deletefileSelected"),
                variant: "contained",
                color: "primary",
                startIcon: <Close />,
                disableElevation: true,
                style: {
                  flex: 1,
                  height: "50px",
                  width: "100%",
                  background: "#fff",
                  border: "1px solid #1D6F42",
                  borderRadius: "7px",
                  display: "flex",
                  justifyContent: "center",
                  alignItems: "center",
                  color: "#1D6F42",
                },
              }}
            ></Button>
          )}
          <input
            type="file"
            ref={fileInputRef1}
            hidden
            multiple
            style={{ display: "none" }}
            onChange={(e) => handleFileSelection(e, "excel")}
          />
        </div>
        <div className={styles.option}>
          <Image src={zipIcon} alt="easybroker" />
          {!zipFile && (
            <Button
              {...{
                onClick: () => fileInputRef2.current?.click(),
                children: t("uploadZip"),
                variant: "contained",
                color: "primary",
                startIcon: <UploadFile />,
                disableElevation: true,
                style: {
                  flex: 1,
                  height: "50px",
                  width: "100%",
                  backgroundColor: "#E23052",
                  borderRadius: "7px",
                  display: "flex",
                  justifyContent: "center",
                  alignItems: "center",
                  color: "#FFF",
                },
              }}
            ></Button>
          )}
          {zipFile && (
            <Button
              {...{
                onClick: () => setZipFile(undefined),
                children: t("deletefileSelected"),
                variant: "contained",
                color: "primary",
                startIcon: <Close />,
                disableElevation: true,
                style: {
                  flex: 1,
                  height: "50px",
                  width: "100%",
                  backgroundColor: "#fff",
                  border: "1px solid #E23052",
                  borderRadius: "7px",
                  display: "flex",
                  justifyContent: "center",
                  alignItems: "center",
                  color: "#E23052",
                },
              }}
            ></Button>
          )}
          <input
            type="file"
            ref={fileInputRef2}
            hidden
            multiple
            style={{ display: "none" }}
            onChange={(e) => handleFileSelection(e, "zip")}
          />
        </div>
      </div>
      <FormInput
        required={false}
        variationConfig={{
          type: "accept_and_cancel",
          fullWidth: true,
          accept: {
            onClick: handleSubmit,
            children: t("create"),
            variant: "contained",
            color: "primary",
            disableElevation: true,
            disabled:
              requestStatusExcels.loading || requestStatusimport.loading,
            loading: requestStatusExcels.loading || requestStatusimport.loading,
            style: {
              width: "fit-content",
              height: "54px",
              padding: "0 28px",
              backgroundColor: PRIMARY_COLOR,
              borderRadius: "100px",
              display: "flex",
              justifyContent: "center",
              alignItems: "center",
              color: "#fff",
            },
          },
          cancel: {
            onClick: onCancel,
            children: t("back"),
            variant: "contained",
            color: "primary",
            disableElevation: true,
            style: {
              width: "fit-content",
              height: "54px",
              padding: "0 28px",
              backgroundColor: "#5E5E5E",
              borderRadius: "100px",
              display: "flex",
              justifyContent: "center",
              alignItems: "center",
              color: "#fff",
            },
          },
        }}
      />
    </>
  );
};

export default ExcelImportation;
