/* eslint-disable @typescript-eslint/no-explicit-any */
import { FormikProps } from "formik";
import { LoginFormData } from "../types";
import { FormInputVariations, SelectOptionsProps } from "../../FormInput/types";
import { PRIMARY_COLOR, TERCIARY_COLOR, WHITE } from "@/styles/constants";
import styles from "../styles/LoginModal.module.scss";
import google from "@/assets/icons/google.svg";
import fb from "@/assets/icons/fb.svg";
import Image from "next/image";

export const initialStateLoginForm: LoginFormData = {
  email: "",
  password: "",
  rememberMe: false,
  phoneNumber: {
    select: "142",
    input: "",
  },
};

export const keysWelcome = ["header1", "divider", "register", "login"];

export const keysLoginForm = [
  "header1",
  "divider",
  "email",
  "password",
  "dividerOr",
  "googleLogin",
  "facebookLogin",
  "rememberMe",
  "phoneNumber",
  "code",
  "submit",
];

export const WelcomeInputs =
  (register: () => any, login: () => any) =>
  (
    _key: keyof LoginFormData,
    _formikMetadata: FormikProps<LoginFormData>,
    t: any
  ): Record<keyof LoginFormData | string, FormInputVariations> => {
    return {
      header1: {
        type: "title_and_subtitle",
        texts: {
          title: t("welcome"),
          subtitle: t("accessToYourAccount"),
          style: {
            fontWeight: "700",
          },
        },
      },
      divider: {
        type: "divider",
      },
      register: {
        type: "button",
        fullWidth: true,
        button: {
          onClick: register,
          children: t("register"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundImage: `linear-gradient(to right, #0C218D, #2176F0)`,
            borderRadius: "10px",
            maxWidth: "428px",
          },
        },
      },
      login: {
        type: "button",
        fullWidth: true,
        button: {
          onClick: login,
          children: t("login"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundImage: `linear-gradient(to right, #0C218D, #2176F0)`,
            borderRadius: "10px",
            maxWidth: "428px",
          },
        },
      },
    };
  };

export const LoginFormInputs =
  (
    phoneLogin: boolean,
    phoneCodes: SelectOptionsProps[],
    enterCodeMode: boolean,
    minutes: number,
    seconds: number,
    resendCode: () => any,
    loading?: boolean
  ) =>
  (
    key: keyof LoginFormData,
    formikMetadata: FormikProps<LoginFormData>,
    t: any
  ): Record<keyof LoginFormData | string, FormInputVariations> => {
    const { values, setValues, handleChange, submitForm } = formikMetadata;

    const inputs: Record<keyof LoginFormData | string, FormInputVariations> = {
      header1: {
        type: "title_and_subtitle",
        texts: {
          title: t("login"),
        },
      },
      divider: {
        type: "divider",
      },
    };

    if (!phoneLogin) {
      inputs.email = {
        type: "text",
        fullWidth: true,
        inputProps: {
          variant: "simple",
          value: values[key] as string,
          placeholder: "",
          onChange: handleChange(key),
        },
      };
      inputs.password = {
        type: "text",
        fullWidth: true,
        inputProps: {
          variant: "simple",
          passwordMode: true,
          value: values[key] as string,
          placeholder: "",
          onChange: handleChange(key),
        },
      };

      inputs.dividerOr = {
        type: "children",

        children: (
          <div className={styles.dividerOr}>
            <div className={styles.line}></div>
            <p className={styles.or}>{t("or")}</p>
          </div>
        ),
      };

      inputs.googleLogin = {
        type: "button",
        fullWidth: true,
        button: {
          onClick: submitForm,
          children: (
            <>
              <Image src={google} alt={"google"} />
              {t("loginWithGoogle")}
            </>
          ),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          style: {
            width: "100%",
            height: "50px",
            background: "#FFF",
            color: "#000",
            display: "flex",
            gap: "10px",
            boxShadow: "0 0 20px #4271D629",
            borderRadius: "100px",
          },
        },
      };
      inputs.facebookLogin = {
        type: "button",
        fullWidth: true,
        button: {
          onClick: submitForm,
          children: (
            <>
              <Image src={fb} alt={"fb"} />
              {t("loginWithFacebook")}
            </>
          ),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          style: {
            width: "100%",
            height: "50px",
            background: "#4271D6",
            color: "#fff",
            display: "flex",
            gap: "10px",
            borderRadius: "100px",
          },
        },
      };
      inputs.rememberMe = {
        type: "radios-group",
        fullWidth: true,
        hideLabel: true,
        radios: [
          {
            value: "rememberMe",
            label: t("rememberMe"),
            checked: Boolean(values[key]),
            onClick: () => setValues({ ...values, [key]: true }),
          },
        ],
      };
      inputs.submit = {
        type: "button",
        fullWidth: true,
        button: {
          onClick: submitForm,
          children: t("login"),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          loading,
          style: {
            width: "100%",
            height: "50px",
            background: TERCIARY_COLOR,
            borderRadius: "100px",
            maxWidth: "218px",
          },
        },
      };
    }

    if (phoneLogin) {
      if (enterCodeMode) {
        inputs.code = {
          type: "code_input",
          hideLabel: true,
          inputProps: {
            value: values[key] as string,
            onChange: handleChange(key),
          },
        };
        inputs.submit = {
          type: "accept_and_cancel",
          cancel: {
            onClick: resendCode,
            children:
              t("resend") +
              " " +
              `(${
                (minutes < 10 ? "0" + minutes : minutes) +
                ":" +
                (seconds < 10 ? "0" + seconds : seconds)
              })`,
            variant: "contained",
            color: "primary",
            disabled: Boolean(minutes && seconds),
            style: {
              width: "100%",
              height: "50px",
              backgroundColor: WHITE,
              color: PRIMARY_COLOR,
              borderRadius: "10px",
              maxWidth: "428px",
            },
          },
          accept: {
            onClick: submitForm,
            children: t("validate"),
            variant: "contained",
            color: "primary",
            style: {
              width: "100%",
              height: "50px",
              backgroundColor: PRIMARY_COLOR,
              borderRadius: "10px",
              maxWidth: "428px",
            },
          },
        };
      } else {
        inputs.phoneNumber = {
          type: "select_input",
          fullWidth: true,
          input: {
            value: values.phoneNumber?.input ?? "",
            placeholder: t("enter10Characters"),
            onChange: (e) =>
              setValues({
                ...values,
                phoneNumber: {
                  ...values.phoneNumber,
                  select: values?.phoneNumber?.select ?? "",
                  input: e.target.value,
                },
              }),
          },
          select: {
            options: phoneCodes,
            selectedItem: values.phoneNumber?.select as string,
            placeholder: t(key),
            onClickItem: (val) =>
              setValues({
                ...values,
                phoneNumber: {
                  ...values.phoneNumber,
                  input: values?.phoneNumber?.input ?? "",
                  select: val as string,
                },
              }),
          },
        };

        inputs.submit = {
          type: "button",
          fullWidth: true,
          button: {
            onClick: submitForm,
            children: t("sendCode"),
            variant: "contained",
            color: "primary",
            loading,
            style: {
              width: "100%",
              height: "50px",
              background: TERCIARY_COLOR,
              borderRadius: "10px",
              maxWidth: "428px",
            },
          },
        };
      }
    }

    return inputs;
  };
