/* eslint-disable @next/next/no-img-element */
/* eslint-disable react-hooks/exhaustive-deps */
import React, { SetStateAction, useEffect, useRef, useState } from "react";
import FormMaker from "../FormMaker/FormMaker";
import {
  ImportPropertyFormInputs,
  initialStateImportPropertyForm,
  keysImportPropertyForm,
  requiredFieldsImportPropertyForm,
} from "./forms/formInputs";
import {
  GetPropertCategoriesParams,
  GetPropertCategoriesResponse,
  GetPropertTypesParams,
  GetPropertTypesResponse,
  GetPropertUrbTypesParams,
  GetPropertUrbTypesResponse,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import {
  GetPropertyCategories,
  GetPropertyTypes,
  GetPropertyUrbTypes,
} from "@/lib/services/redux/reducers/properties/propertiesActions";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import { SelectOptionsProps } from "../FormInput/types";
import GenerateWithAiModal from "../GenerateWithAiModal/GenerateWithAiModal";
import { importPropertyFormData } from "./types";
import { FormikProps } from "formik";
import styles from "./styles.module.scss";
import Stepper from "../Stepper/Stepper";
import { KeyboardArrowLeft, KeyboardArrowRight } from "@mui/icons-material";

interface ImportPropertyFormProps {
  handleSubmit: (values: importPropertyFormData) => unknown;
  loading: boolean;
  easyBrokerData?: PropertyFromEasyBrokertFull;
}

const ImportPropertyForm: React.FC<ImportPropertyFormProps> = ({
  handleSubmit,
  loading,
  easyBrokerData,
}) => {
  const formikRef = useRef<FormikProps<importPropertyFormData>>(null);

  const [step, setStep] = useState<number>(0);

  const [currentImageIndex, setCurrentImageIndex] = useState(0);

  const [FormErrors, setFormErrors] = useState<
    (keyof importPropertyFormData)[]
  >([]);

  const { fetcher: fetcherTypes } = useRequestHandler<
    GetPropertTypesResponse,
    GetPropertTypesParams
  >(GetPropertyTypes);
  const { fetcher: fetcherUrbTypes } = useRequestHandler<
    GetPropertUrbTypesResponse,
    GetPropertUrbTypesParams
  >(GetPropertyUrbTypes);
  const { fetcher: fetcherCategories } = useRequestHandler<
    GetPropertCategoriesResponse,
    GetPropertCategoriesParams
  >(GetPropertyCategories);

  const [propertyTypes, setPropertyTypes] = useState<SelectOptionsProps[]>([]);
  const [categories, setCategories] = useState<SelectOptionsProps[]>([]);
  const [urbTypes, setUrbTypes] = useState<SelectOptionsProps[]>([]);

  const [openIaModal, setOpenIaModal] = useState(false);

  const retryFunction = async () => {
    const typeshere = await fetcherTypes({});

    if (typeshere.status === "success") {
      setPropertyTypes(
        typeshere.response.types.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }

    const urbTypeshere = await fetcherUrbTypes({});

    if (urbTypeshere.status === "success") {
      setUrbTypes(
        urbTypeshere.response.sets.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }
    const categorieshere = await fetcherCategories({});

    if (categorieshere.status === "success") {
      setCategories(
        categorieshere.response.categories.map((d) => {
          return {
            label: d.nombre,
            name: d.id,
            value: d.id,
          };
        })
      );
    }
  };

  useEffect(() => {
    retryFunction();
  }, []);

  const handleIA = () => {
    setOpenIaModal(!openIaModal);
  };

  useEffect(() => {
    if (easyBrokerData) {
      const payload: importPropertyFormData = {
        title: easyBrokerData?.title,
        propertyType: easyBrokerData?.propertyType,
        operationType: easyBrokerData?.category,
        complex: easyBrokerData?.sets,
        address: easyBrokerData?.location?.name,
        identifier: easyBrokerData?.alias ?? "",
        country: "",
        state: "",
        city: "",
        location: {
          lat: easyBrokerData?.location?.latitude,
          lng: easyBrokerData?.location?.longitude,
        },
        locationCenter: {
          lat: easyBrokerData?.location?.latitude,
          lng: easyBrokerData?.location?.longitude,
        },
        price: easyBrokerData?.price,
        age: easyBrokerData?.age,
        builtArea: easyBrokerData?.construction_size,
        landArea: easyBrokerData?.lot_size,
        bedrooms: easyBrokerData?.bedrooms,
        fullBathrooms: easyBrokerData?.bathrooms ?? 0,
        halfBathrooms: easyBrokerData?.half_bathrooms ?? 0,
        parkingSpots: easyBrokerData?.parking_spaces ?? 0,
        floors: easyBrokerData?.floors,
        hasWater: easyBrokerData?.isWatter ? 1 : 0,
        hasElectricity: easyBrokerData?.isLight ? 1 : 0,
        hasGas: easyBrokerData?.isGas ? 1 : 0,
        hasInternet: easyBrokerData?.isWifi ? 1 : 0,
        privateSecurity: easyBrokerData?.isSecurity ? 1 : 0,
        nearbySchools: easyBrokerData?.isSchool ? 1 : 0,
        maintenanceIncluded: easyBrokerData?.isMaintenance ? 1 : 0,
        accessibleForDisabled: easyBrokerData?.isDisabled ? 1 : 0,
        hasPool: easyBrokerData?.isPool ? 1 : 0,
        hasSecurityCameras: easyBrokerData?.isCamera ? 1 : 0,
        furnished: easyBrokerData?.isFurnished ? 1 : 0,
        beds: easyBrokerData?.isBed ? 1 : 0,
        closet: easyBrokerData?.isCloset ? 1 : 0,
        livingroom: easyBrokerData?.isHall ? 1 : 0,
        diningroom: easyBrokerData?.isDiningRoom ? 1 : 0,
        kitchen: easyBrokerData?.isKitchen ? 1 : 0,
        aa: easyBrokerData?.isAA ? 1 : 0,
        refrigerator: easyBrokerData?.isFridge ? 1 : 0,
        stove: easyBrokerData?.isStove ? 1 : 0,
        microwave: easyBrokerData?.isMicrowave ? 1 : 0,
        minioven: easyBrokerData?.isMiniOven ? 1 : 0,
        oven: easyBrokerData?.isOven ? 1 : 0,
        washingmachine: easyBrokerData?.isWashingMachine ? 1 : 0,
        driyingmachine: easyBrokerData?.isDryer ? 1 : 0,
        others: easyBrokerData?.other,
        description: easyBrokerData?.description,
        addVideo: 0,
        propertyFiles: [],
      };
      formikRef?.current?.setValues(payload);
    }
  }, [easyBrokerData]);

  const handlePrevImage = () => {
    if (!easyBrokerData?.property_images?.length) return;
    setCurrentImageIndex((prev) =>
      prev === 0 ? easyBrokerData.property_images.length - 1 : prev - 1
    );
  };

  const handleNextImage = () => {
    if (!easyBrokerData?.property_images?.length) return;
    setCurrentImageIndex((prev) =>
      prev === easyBrokerData.property_images.length - 1 ? 0 : prev + 1
    );
  };

  return (
    <div className={styles.maxContainer}>
      <div className={styles.stepperContainer}>
        <Stepper steps={3} currentIndex={step} />
      </div>
      {easyBrokerData && step === 0 && (
        <div
          className={styles.imagesContainer}
          style={{
            backgroundImage: `url(${
              easyBrokerData?.property_images?.[currentImageIndex].url ?? ""
            })`,
          }}
        >
          <div className={styles.blur} />
          <img
            src={easyBrokerData?.property_images?.[currentImageIndex].url ?? ""}
            alt={`img-${currentImageIndex}`}
          />
          {/* Flecha Izquierda */}
          <button onClick={handlePrevImage} className={styles.arrowLeft}>
            <KeyboardArrowLeft />
          </button>

          {/* Flecha Derecha */}
          <button onClick={handleNextImage} className={styles.arrowRight}>
            <KeyboardArrowRight />
          </button>
        </div>
      )}
      <div className={styles.formContainer}>
        <FormMaker<importPropertyFormData>
          keys={keysImportPropertyForm}
          innerRef={formikRef}
          initialState={initialStateImportPropertyForm()}
          requiredFields={requiredFieldsImportPropertyForm}
          handleSubmit={handleSubmit}
          errorLabels={FormErrors}
          formSteps={ImportPropertyFormInputs(
            propertyTypes ?? [],
            urbTypes ?? [],
            categories ?? [],
            step,
            setStep,
            setFormErrors as React.Dispatch<SetStateAction<string[]>>,
            loading
          )}
        />
        {openIaModal && (
          <GenerateWithAiModal
            modalProps={{
              isOpen: openIaModal,
              toggle: handleIA,
              showToggle: true,
            }}
            values={formikRef.current?.values}
            setValues={formikRef?.current?.setValues}
          />
        )}
      </div>
    </div>
  );
};

export default ImportPropertyForm;
