import React, { useRef, useState } from "react";
import ModalMaker, { ModalMakerProps } from "../ModalMaker/ModalMaker";
import FormMaker from "../FormMaker/FormMaker";
import { LoginFormData } from "./types";
import {
  initialStateLoginForm,
  keysLoginForm,
  LoginFormInputs,
} from "./forms/formInputs";
import useCountries from "@/hooks/useCountries/useCountries";
import { validateEmailLogin } from "./validations/validators";
import useRequestHandler from "@/hooks/useRequestHandler/useRequestHandler";
import {
  loginWithEmailParams,
  loginWithEmailResponse,
} from "@/lib/services/redux/reducers/user/userActions.d";
import { loginWithEmail } from "@/lib/services/redux/reducers/user/userActions";
import { FormikProps } from "formik";
import { useTimer } from "react-timer-hook";
import styles from "./styles/LoginModal.module.scss";
import { useTranslations } from "next-intl";
import { useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";

interface LoginModalProps {
  modalProps: ModalMakerProps;
}

const LoginModal: React.FC<LoginModalProps> = ({ modalProps }) => {
  const navigation = useRouter();
  const [phoneLogin] = useState<boolean>(false);
  const formikRef = useRef<FormikProps<LoginFormData>>(null);

  const [formErrors, setFormErrors] = useState<(keyof LoginFormData)[]>([]);

  const { minutes, seconds, restart } = useTimer({
    expiryTimestamp: new Date(),
  });

  const { phoneCodes } = useCountries();

  const t = useTranslations();

  const { fetcher: handleEmail, requestStatus: handleEmailStatus } =
    useRequestHandler<loginWithEmailResponse, loginWithEmailParams>(
      loginWithEmail
    );

  const handleResendCode = async () => {
    if (formikRef.current) {
      const selectedCode = formikRef.current.values?.phoneNumber?.select;
      const phoneObj = phoneCodes.find((d) => d.value === selectedCode);
      if (!phoneObj) return;
      // const lada1 = Number(phoneObj.label.replace("+", ""));

      const query = { status: "" };

      if (query.status === "success") {
        restart(new Date(new Date().getTime() + 1800000));
      }
    }
  };

  const handleSubmit = async (values: LoginFormData) => {
    const validation = validateEmailLogin(values);

    if (validation.length === 0) {
      handleEmail(values);
    } else {
      setFormErrors(validation);
    }
  };

  return (
    <ModalMaker
      {...modalProps}
      showToggle
      style={{
        maxWidth: "468px",
      }}
    >
      <div className={styles.loginModalContainer}>
        <FormMaker<LoginFormData>
          keys={keysLoginForm}
          initialState={initialStateLoginForm}
          handleSubmit={handleSubmit}
          innerRef={formikRef}
          errorLabels={formErrors}
          formSteps={LoginFormInputs(
            phoneLogin,
            phoneCodes,
            false,
            minutes,
            seconds,
            handleResendCode,
            handleEmailStatus.loading
          )}
        />
        <div
          onClick={() => {
            navigation.push(AllRoutes.REGISTER);
            modalProps.toggle();
          }}
          className={styles.buttonsContainer}
        >
          <div className={styles.toggleLoginButton}>
            <p>{t("registerText")}</p>
          </div>
        </div>
      </div>
    </ModalMaker>
  );
};

export default LoginModal;
