import {LoginFormData} from '../types';

export const validateEmailLogin = ({
  email,
  password,
}: Partial<LoginFormData>): (keyof LoginFormData)[] => {
  const labels: (keyof LoginFormData)[] = [];

  if (typeof email !== 'string' || !email.length) {
    labels.push('email');
  }
  if (typeof password !== 'string' || !password.length) {
    labels.push('password');
  }

  return labels;
};

export const validatePhoneLogin = ({
  phoneNumber,
}: Partial<LoginFormData>): (keyof LoginFormData)[] => {
  const labels: (keyof LoginFormData)[] = [];

  if (
    typeof phoneNumber?.input !== 'string' ||
    !phoneNumber.input.length ||
    typeof phoneNumber?.select !== 'string' ||
    !phoneNumber.select.length
  ) {
    labels.push('phoneNumber');
  }

  return labels;
};
