import React from "react";
import styles from "./styles/LogoutComponent.module.scss";
import useAuthentication from "../../hooks/useAuthentication/useAuthentication";
import { Button } from "@mui/material";
import { useTranslations } from "next-intl";
import { PRIMARY_COLOR } from "@/styles/constants";

const LogoutComponent: React.FC = () => {
  const t = useTranslations();

  const { logout } = useAuthentication();

  const handleLogout = () => {
    logout();
  };

  return (
    <div className={styles.container}>
      <p className={styles.titleLogout}>{t("areYouSureToLogout")}</p>
      <Button
        {...{
          onClick: handleLogout,
          children: t("accept"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            borderRadius: "8px",
            boxShadow: `0px 0px 10px ${PRIMARY_COLOR + "7a"}`,
            background: `linear-gradient(45deg, #2176F0, #0C218D)`,
            color: "#fff",
          },
        }}
      />
    </div>
  );
};

export default LogoutComponent;
