/* eslint-disable @typescript-eslint/no-explicit-any */
import React from "react";
import styles from "./styles/ModalMaker.module.scss";
import { CircularProgress, IconButton, Modal } from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";

export interface ModalMakerProps {
  isOpen: boolean;
  toggle: () => any;
  title?: string;
  showToggle?: boolean;
  children?: Element | React.FC | any;
  style?: React.CSSProperties;
  showGeneralLoading?: boolean;
}

const ModalMaker: React.FC<ModalMakerProps> = (props) => {
  const { isOpen, toggle, title, children, showToggle, style } = props;
  return (
    <Modal open={isOpen} onClose={toggle}>
      <div className={styles.container}>
        <div className={styles.modalContent} style={style}>
          {toggle && showToggle && (
            <IconButton className={styles.closeIcon} onClick={toggle}>
              <CloseIcon sx={{ color: "#000" }} />
            </IconButton>
          )}
          {title && <span className={styles.header}>{title}</span>}
          {children}
          {props.showGeneralLoading && (
            <div className={styles.loading}>
              <CircularProgress color="primary" />
            </div>
          )}
        </div>
      </div>
    </Modal>
  );
};

export default ModalMaker;
