import React from "react";
import styles from "./styles.module.scss";
import { socials } from "../Footer/constants/socials";
import Image from "next/image";
import { Button } from "@mui/material";
import { PersonOutline } from "@mui/icons-material";
import { useTranslations } from "next-intl";
import { GetProfileResponse } from "@/lib/services/redux/reducers/user/userActions.d";
import { usePathname, useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";

interface PersonProfileCardProps {
  profile: GetProfileResponse["users"] | null;
}

const PersonProfileCard: React.FC<PersonProfileCardProps> = ({ profile }) => {
  const t = useTranslations();
  const navigate = useRouter();

  const realpathname = usePathname();

  const pathname = (realpathname ?? "").replace("/es", "").replace("/en", "");

  const gotoprofile = () => {
    navigate.push(AllRoutes.PROFILE + "/" + (profile?.id ?? "--"));
  };

  return (
    <div className={styles.profilePart}>
      <div className={styles.socials}>
        {socials("", "", "", "", "")
          .slice(1, 7)
          .map((d, index) => {
            return (
              <div
                key={index}
                className={styles.socialButton}
                onClick={() => window.open(d.link)}
              >
                <div className={styles.content}>
                  <Image
                    src={d.image}
                    style={{ width: "100%", height: "100%" }}
                    alt={"social" + d.link}
                  />
                </div>
              </div>
            );
          })}
      </div>
      <div className={styles.container}>
        <div
          className={styles.image}
          style={{ backgroundImage: `url(${profile?.img ?? ""})` }}
        ></div>
        <div className={styles.info}>
          <div className={styles.texts}>
            <p>
              {t("followers")}
              <span style={{ color: "#E23052", fontSize: "15.49px" }}>
                {profile?.totalFollowme.toString() ?? ""}
              </span>
            </p>
            <p>
              {t("following")}
              <span style={{ color: "#E23052", fontSize: "15.49px" }}>
                {profile?.totalFollowme.toString() ?? ""}
              </span>
            </p>
          </div>
          <p className={styles.name}>
            {profile?.nombre && profile?.apellido
              ? `${profile?.nombre} ${profile?.apellido}`
              : "--"}
          </p>
          <p className={styles.label}>{profile?.perfilEmpresarial ?? "--"}</p>
          <p className={styles.phone}>{profile?.telefonoPersonal ?? "--"}</p>
          {pathname !== AllRoutes.PROFILE && (
            <Button
              startIcon={<PersonOutline />}
              variant="contained"
              color="primary"
              disableElevation
              className={styles.button}
              onClick={gotoprofile}
            >
              {t("viewProfile")}
            </Button>
          )}
        </div>
      </div>
    </div>
  );
};

export default PersonProfileCard;
