/* eslint-disable @next/next/no-img-element */
import React from "react";
import styles from "./styles.module.scss";
import { useTranslations } from "next-intl";
import beds from "@/assets/icons/beds.svg";
import baths from "@/assets/icons/baths.svg";
import homes from "@/assets/icons/homes.svg";
import parkings from "@/assets/icons/parkings.svg";
import Image from "next/image";
import { formatCurrencyMXN } from "@/lib/utils/format-currenty-mxn";
import { useRouter } from "next/navigation";
import ProfileCard from "./components/ProfileCard/ProfileCard";
import { IPropertyFeatured } from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import propertyDetailIcon2 from "@/assets/icons/propertyDetailsIcon2.svg";
import { allPropertyFeatures } from "@/screens/PropertyView/constants/propertyDetails";

export interface PropertyCardProps {
  fulldata: IPropertyFeatured;
  type: "super" | "simple" | "original";
  mode?: "vertical" | "horizontal";
  totalBeds: number;
  totalBaths: number;
  totalHomes: number;
  totalParkings: number;
  price: number;
  categoy: "rent" | "sale";
  title: string;
  description: string;
  img: string | null;
  userImg: string | null;
  userTotalProperties: number;
  userId: string;
  slug: string;
  minWidth?: string;
  user: IPropertyFeatured["users"];
}

const PropertyCard: React.FC<PropertyCardProps> = (props) => {
  const {
    type,
    totalBeds,
    fulldata,
    totalBaths,
    totalHomes,
    totalParkings,
    price,
    categoy,
    title,
    description,
    img,
    userImg,
    userTotalProperties,
    userId,
    user,
    slug,
    minWidth,
    mode = "vertical",
  } = props;

  const router = useRouter();

  const t = useTranslations();

  const handleClick = (slug: string) => {
    if (slug) {
      router.push(`/property/${slug}`);
    }

    if (userTotalProperties && userId) {
    }
  };

  return (
    <div
      className={mode === "horizontal" ? styles.cardHorizontal : styles.card}
      onClick={() => handleClick(slug)}
      style={minWidth ? { minWidth } : undefined}
    >
      <div className={styles.imageContainer}>
        {img && (
          <img
            src={img}
            alt={title}
            style={{ objectFit: "cover", width: "100%", height: "100%" }}
          />
        )}

        {type !== "original" && (
          <p
            className={[
              styles.badge,
              type === "super" ? styles.superFeatured : styles.featured,
            ].join(" ")}
          >
            {t(type === "super" ? "superFeatured" : "featured")}
          </p>
        )}
      </div>

      <div className={styles.contentInCardMode}>
        <div className={styles.propertyParts}>
          <div className={styles.personCircle}>
            {userImg && (
              <ProfileCard
                userImg={userImg}
                name={user.nombre + " " + user.apellido}
                numProperties={user?.totalProperties}
                numFollowers={user?.totalFollowme}
                id={user.id}
              />
            )}
          </div>
          <div className={styles.items}>
            <Image src={beds} alt={"beds"} />
            <p>{totalBeds}</p>
          </div>
          <div className={styles.items}>
            <Image src={baths} alt={"baths"} />
            <p>{totalBaths}</p>
          </div>
          <div className={styles.items}>
            <Image src={homes} alt={"homes"} />
            <p>{totalHomes}</p>
          </div>
          <div className={styles.items}>
            <Image src={parkings} alt={"parkings"} />
            <p>{totalParkings}</p>
          </div>
        </div>
        <div className={styles.prices}>
          <p className={styles.price}>{formatCurrencyMXN(price)} MXN</p>
          <p className={categoy === "rent" ? styles.rent : styles.sale}>
            {t(categoy)}
          </p>
        </div>
        <div className={styles.texts}>
          <p className={styles.title}>
            {title?.length > 28 ? title?.slice(0, 28) + "..." : title}
          </p>
          <p className={styles.desc}>
            {description?.length > 80
              ? description?.slice(0, 80) + "..."
              : description}
          </p>
        </div>
      </div>
      <div className={styles.contentInListMode}>
        <div className={styles.propertyParts}>
          <div className={styles.row} style={{ width: "100%" }}>
            <div style={{ width: "80%" }}>
              <div
                className={styles.row}
                style={{ width: "100%", marginBottom: "10px" }}
              >
                <div className={styles.rowItem}>
                  <p className={styles.price}>{formatCurrencyMXN(price)} MXN</p>
                  <p className={categoy === "rent" ? styles.rent : styles.sale}>
                    {t(categoy)}
                  </p>
                </div>
                <div
                  style={{ display: "flex", alignItems: "center", gap: "10px" }}
                >
                  <div className={styles.items}>
                    <Image src={beds} alt={"beds"} />
                    <p>{totalBeds}</p>
                  </div>
                  <div className={styles.items}>
                    <Image src={baths} alt={"baths"} />
                    <p>{totalBaths}</p>
                  </div>
                  <div className={styles.items}>
                    <Image src={homes} alt={"homes"} />
                    <p>{totalHomes}</p>
                  </div>
                  <div className={styles.items}>
                    <Image src={parkings} alt={"parkings"} />
                    <p>{totalParkings}</p>
                  </div>
                </div>
              </div>
              <p className={styles.title}>{props.title}</p>
            </div>
            {userImg && (
              <ProfileCard
                userImg={userImg}
                name={user.nombre + " " + user.apellido}
                numProperties={user?.totalProperties}
                numFollowers={user?.totalFollowme}
                id={user.id}
              />
            )}
          </div>
          <p className={styles.desc}>{props.description}</p>
          <div className={styles.propertyFeatures}>
            {allPropertyFeatures(fulldata)
              .filter((d) => d.value === "yes")
              .map((d) => {
                return (
                  <p key={d.name} className={styles.sale}>
                    <Image
                      src={d.icon}
                      alt={d.name}
                      style={{ width: "22px", height: "22px" }}
                    />
                    {t(d.name)}
                  </p>
                );
              })}
          </div>
          <div className={styles.constructionDetails}>
            <div className={styles.detail}>
              <div className={styles.icon}>
                <Image src={propertyDetailIcon2} alt={"details"} />
              </div>
              <div className={styles.texts}>
                <p className={styles.title}>{t("area_built")}</p>
                <p className={styles.value}>
                  {fulldata?.m2Construidos ?? "S/N"}
                </p>
              </div>
            </div>
            <div className={styles.detail}>
              <div className={styles.icon}>
                <Image src={propertyDetailIcon2} alt={"details"} />
              </div>
              <div className={styles.texts}>
                <p className={styles.title}>{t("area_land")}</p>
                <p className={styles.value}>{fulldata?.m2Terreno ?? "S/N"}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default PropertyCard;
