import React, { useState } from "react";
import styles from "./styles.module.scss";
import Image from "next/image";
import { Button, Fade, Popper } from "@mui/material";
import { useTranslations } from "next-intl";
import { PersonOutline } from "@mui/icons-material";
import { AllRoutes } from "@/lib/routes";
import { useRouter } from "next/navigation";

export interface ProfileCardProps {
  userImg: string;
  name: string;
  numProperties: number;
  numFollowers: number;
  id: string;
}

const ProfileCard: React.FC<ProfileCardProps> = ({
  userImg,
  id,
  name,
  numFollowers,
  numProperties,
}) => {
  const [openDropdown, setOpenDropdown] = useState<HTMLDivElement | null>(null);

  const navigate = useRouter();

  const open = Boolean(openDropdown);

  const t = useTranslations();

  const gotoprofile = () => {
    navigate.push(AllRoutes.PROFILE + "/" + (id ?? "--"));
  };

  return (
    <>
      <div
        className={styles.userImg}
        onMouseEnter={(e) => setOpenDropdown(open ? null : e.currentTarget)}
      >
        <Image
          src={userImg}
          alt={"profile-image"}
          fill
          style={{ objectFit: "cover" }}
          sizes="55.78px"
        />
        <Popper
          open={open}
          style={{ zIndex: 10000 }}
          anchorEl={openDropdown}
          transition
          placement="bottom"
        >
          {({ TransitionProps }) => (
            <Fade {...TransitionProps} timeout={350}>
              <div
                className={styles.popperBox}
                onMouseLeave={() => setOpenDropdown(null)}
              >
                <div className={styles.imgSpace}>
                  <div
                    className={styles.userImg}
                    onClick={(e) =>
                      setOpenDropdown(open ? null : e.currentTarget)
                    }
                  >
                    <Image
                      src={userImg}
                      alt={"profile-image"}
                      fill
                      style={{
                        objectFit: "cover",
                        border: "2px solid #1AB70D",
                      }}
                      sizes="55.78px"
                    />
                  </div>
                </div>
                <p className={styles.name}>{name}</p>
                <div className={styles.followersRow}>
                  <div className={styles.followers}>
                    <p className={styles.followersText}>{numProperties}</p>
                    <p
                      className={styles.followersText}
                      style={{ fontWeight: "400" }}
                    >
                      {t("properties")}
                    </p>
                  </div>
                  <div className={styles.followers}>
                    <p className={styles.followersText}>{numFollowers}</p>
                    <p
                      className={styles.followersText}
                      style={{ fontWeight: "400" }}
                    >
                      {t("followers")}
                    </p>
                  </div>
                </div>
                <Button
                  startIcon={<PersonOutline />}
                  variant="contained"
                  color="primary"
                  disableElevation
                  className={styles.button}
                  onClick={gotoprofile}
                >
                  {t("viewProfile")}
                </Button>
              </div>
            </Fade>
          )}
        </Popper>
      </div>
    </>
  );
};

export default ProfileCard;
