import { Box, Fade, InputBase, Popper } from "@mui/material";
import React, { useEffect, useRef, useState } from "react";
import styles from "./styles.module.scss";
import { KeyboardArrowDownRounded } from "@mui/icons-material";
import { useTranslations } from "use-intl";

interface RangeSelectorProps {
  value: number[];
  placeholder: string;
  setValue: (numbers: number[]) => unknown;
}

const RangeSelector: React.FC<RangeSelectorProps> = (props) => {
  const t = useTranslations();
  const [anchorEl, setAnchorEl] = useState<HTMLElement | null>(null);
  const buttonDiv = useRef<HTMLDivElement>(null);

  const [dynamicWidth, setDynamicWidth] = useState(0);

  const open = Boolean(anchorEl);

  useEffect(() => {
    if (open) {
      setDynamicWidth(open ? (buttonDiv.current?.offsetWidth as number) : 200);
    }
  }, [open]);

  return (
    <>
      <div
        ref={buttonDiv}
        onClick={() => setAnchorEl(anchorEl ? null : buttonDiv.current)}
        className={styles.textInputContainer}
      >
        <p className={styles.selectInnerTab}>{t(props.placeholder)}</p>
        <div className={styles.keyboardArrowDown}>
          <KeyboardArrowDownRounded
            htmlColor={"#000"}
            style={{ fontSize: "30px" }}
          />
        </div>
      </div>
      <Popper
        open={open}
        style={{ zIndex: 10000 }}
        anchorEl={anchorEl}
        transition
      >
        {({ TransitionProps }) => (
          <Fade
            {...TransitionProps}
            style={{ overflow: "visible" }}
            timeout={350}
          >
            <Box
              style={{
                width: dynamicWidth - 2,
                overflow: "visible",
              }}
              className={styles.popperBox}
            >
              <div className={styles.inputRow}>
                <InputBase
                  className={styles.input}
                  placeholder={t("from")}
                  type="number"
                  value={props.value?.[0]}
                  onChange={(d) => {
                    const value = [...(props?.value ?? [])];
                    value[0] = Number(d.target.value);

                    props.setValue(value);
                  }}
                />
                <InputBase
                  className={styles.input}
                  placeholder={t("until")}
                  type="number"
                  value={props.value?.[1]}
                  onChange={(d) => {
                    const value = [...(props?.value ?? [])];
                    value[1] = Number(d.target.value);

                    props.setValue(value);
                  }}
                />
              </div>
            </Box>
          </Fade>
        )}
      </Popper>
    </>
  );
};

export default RangeSelector;
