/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useCallback, useEffect, useState } from "react";
import styles from "./styles/ReactCarousel.module.scss";
import getItemQty from "./helpers/get-items-qty";
import {
  KeyboardArrowLeft,
  KeyboardArrowRight,
  Warning,
} from "@mui/icons-material";
import { Typography } from "@mui/material";
import { arraySplitter } from "@/lib/utils/array-splitter";

type PropTypes = {
  data: any[];
  componentToRender: React.FC<any>;
  skeletonComponentToRender: React.FC<any>;
  loading?: boolean;
  error?: string;
};

const ReactCarousel = ({
  data,
  componentToRender,
  skeletonComponentToRender,
  loading,
  error,
}: PropTypes) => {
  const SkeletonComponent = skeletonComponentToRender;
  const Component = componentToRender;
  const layouts = [
    {
      min: 361,
      itemQty: 1,
    },
    {
      min: 601,
      itemQty: 1,
    },
    {
      min: 750,
      itemQty: 3,
    },
    {
      min: 1100,
      itemQty: 4,
    },
    {
      min: 1201,
      itemQty: 4,
    },
    {
      min: 1400,
      itemQty: 4,
    },
  ];

  const [currentIndex, setCurrentIndex] = useState<number>(0);

  const [itemQty, setItemQty] = useState(
    getItemQty(
      typeof window !== "undefined" ? window.innerWidth : 1200,
      layouts
    )
  );

  useEffect(() => {
    const handleResize = () => {
      setItemQty(getItemQty(window.innerWidth, layouts));
    };

    window.addEventListener("resize", handleResize);

    return () => {
      window.removeEventListener("resize", handleResize);
    };
  }, []);

  const splittedData = useCallback(() => {
    return arraySplitter(data, itemQty as number);
  }, [itemQty, data]);

  const handleClick = useCallback(() => {
    setCurrentIndex((prevIndex) => {
      return prevIndex < splittedData().length - 1 ? prevIndex + 1 : 0;
    });
  }, [splittedData]);

  const handleClickReduce = useCallback(() => {
    setCurrentIndex((prevIndex) => {
      return prevIndex > 0 ? prevIndex - 1 : 0;
    });
  }, [splittedData]);

  return (
    <>
      <div className={styles.carouselContainer}>
        {loading && (
          <div style={{ width: "100%" }}>
            <div className={styles.carouselSlide}>
              {Array(itemQty)
                .fill(3)
                .map((_, index: number) => {
                  return <SkeletonComponent key={index} />;
                })}
            </div>
          </div>
        )}
        {splittedData().length > 1 && (
          <div className={styles.leftButton} onClick={handleClickReduce}>
            <KeyboardArrowLeft sx={{ color: "#5E5E5E", fontSize: 24 }} />
          </div>
        )}
        {data.length > 0 && !loading && (
          <>
            <div style={{ width: "100%" }}>
              {splittedData().map((item, index) => (
                <>
                  {currentIndex === index && (
                    <>
                      <div className={styles.carouselSlide} key={index}>
                        {item.map((renderedItem: any, index: number) => {
                          return (
                            <Component
                              key={"carouselItem-" + index}
                              type={"super"}
                              title={renderedItem.titulo}
                              totalBeds={renderedItem?.habitaciones ?? 0}
                              totalBaths={renderedItem?.baños ?? 0}
                              totalHomes={renderedItem?.pisos ?? 1}
                              totalParkings={renderedItem?.parking ?? 0}
                              price={renderedItem.precio}
                              categoy={
                                renderedItem.categories
                                  ? renderedItem.categories.nombre === "Venta"
                                    ? "sale"
                                    : "rent"
                                  : "rent"
                              }
                              description={renderedItem.descripcion}
                              img={
                                renderedItem.imgs &&
                                renderedItem.imgs.length > 0
                                  ? renderedItem.imgs[0]
                                  : null
                              }
                              userImg={renderedItem.users?.img ?? null}
                              userTotalProperties={
                                renderedItem.users?.totalProperties ?? 0
                              }
                              userId={renderedItem.users?.id ?? ""}
                              slug={renderedItem.slug}
                              user={renderedItem.users}
                              minWidth={"304px"}
                            />
                          );
                        })}
                      </div>
                    </>
                  )}
                </>
              ))}
            </div>
          </>
        )}
        {splittedData().length > 1 && (
          <div className={styles.rightButton} onClick={handleClick}>
            <KeyboardArrowRight sx={{ color: "#5E5E5E", fontSize: 24 }} />
          </div>
        )}
        {error && (
          <div className={styles.carouselSlide}>
            <div className={styles.error}>
              <Warning style={{ fontSize: 100, color: "#7a7a7a" }} />
              <Typography variant="h6" style={{ color: "#7a7a7a" }}>
                {typeof error == "string" ? error : "error"}
              </Typography>
            </div>
          </div>
        )}
      </div>
      <div className={styles.dots}>
        {splittedData() &&
          splittedData()?.length > 0 &&
          splittedData()?.map((image: any, index: number) => (
            <div
              className={
                currentIndex === index ? styles.dot__selected : styles.dot
              }
              key={image._id}
            />
          ))}
      </div>
    </>
  );
};

export default ReactCarousel;
