/* eslint-disable react-hooks/exhaustive-deps */
import React, { useEffect, useRef, useState } from "react";
import styles from "./styles/Stepper.module.scss";
import { arraySplitter } from "@/lib/utils/array-splitter";
import { colorBucleReduced } from "@/styles/constants";

interface StepperProps {
  steps: number;
  currentIndex?: number;
}

const Stepper: React.FC<StepperProps> = (props) => {
  const [possibleColors, setPossibleColors] = useState<string[]>();
  const [gradient, setGradient] = useState<string>("");

  const circlesContainerRef = useRef<HTMLDivElement>(null);
  const prevIndexRef = useRef<number>(props.currentIndex ?? 0);

  useEffect(() => {
    const splitarray = arraySplitter(Array(props.steps).fill(0), 5).map(
      (colors) => {
        const mappingColors = [...colors].map((_d, i) => colorBucleReduced[i]);
        return mappingColors;
      }
    );
    setPossibleColors(splitarray.flat());
  }, []);

  useEffect(() => {
    if (possibleColors && possibleColors.length > 0) {
      const start = (colors: string[]) =>
        `linear-gradient(to right, ${colors.join(", ")})`;

      const passCurrentColors = [...possibleColors].splice(
        0,
        (props?.currentIndex ?? 0) + 1
      );

      for (
        let index = props.currentIndex ?? 0;
        index < possibleColors.length;
        index++
      ) {
        if (
          index === possibleColors.length - 1 &&
          props.currentIndex === possibleColors.length - 1
        ) {
          passCurrentColors.push(possibleColors[possibleColors.length - 1]);
        } else {
          passCurrentColors.push("#c2c2c2");
        }
      }

      setGradient(start(passCurrentColors));
    }
  }, [props.currentIndex, props.steps, possibleColors]);

  useEffect(() => {
    const prevIndex = prevIndexRef.current;
    const currentIndex = props.currentIndex ?? 0;

    if (circlesContainerRef.current && prevIndex !== currentIndex) {
      const direction = currentIndex > prevIndex ? 1 : -1;
      circlesContainerRef.current.scrollBy({
        left: 50 * direction,
        behavior: "smooth",
      });
      prevIndexRef.current = currentIndex;
    }
  }, [props.currentIndex]);

  return (
    <div className={styles.content}>
      <div className={styles.track} style={{ backgroundImage: gradient }}></div>
      <div className={styles.wrapper}>
        {Array(props.steps ?? 1)
          .fill(1)
          .map((d, index) => {
            const isInIndex = (props?.currentIndex ?? 0) >= index;

            return (
              <p
                key={index}
                className={styles.steps}
                style={{
                  backgroundColor: isInIndex
                    ? possibleColors
                      ? possibleColors[index]
                      : "#C2C2C2"
                    : "#C2C2C2",
                  boxShadow: isInIndex
                    ? possibleColors
                      ? `0 0 30px ${possibleColors[index]}45`
                      : `0 0 30px #00000045`
                    : `0 0 30px #00000045`,
                }}
              >
                {d + index}
              </p>
            );
          })}
      </div>
    </div>
  );
};

export default Stepper;
