import React from "react";
import styles from "./styles/SwalComponent.module.scss";
import useRnSwal from "../../hooks/useRnSwal/useRnSwal";
import ModalMaker from "../ModalMaker/ModalMaker";
import FormMaker from "../FormMaker/FormMaker";
import { SwalComponentFormData } from "./types";
import {
  initialStateSwalComponentForm,
  keysSwalComponentForm,
  SwalComponentFormInputs,
} from "./forms/forminputs";
import { useAppSelector } from "@/lib/services/redux/store";

const SwalComponent: React.FC = () => {
  const { clearAll } = useRnSwal();
  const {
    modal: { open, title, text, text2, text3, okFunction, type },
  } = useAppSelector((state) => state.swal);

  return (
    <ModalMaker isOpen={open} toggle={clearAll} showToggle>
      <div className={styles.modalContent}>
        <FormMaker<SwalComponentFormData>
          keys={keysSwalComponentForm}
          initialState={initialStateSwalComponentForm}
          handleSubmit={okFunction}
          formSteps={SwalComponentFormInputs(
            clearAll,
            type,
            title,
            text,
            text2,
            text3
          )}
        />
      </div>
    </ModalMaker>
  );
};

export default SwalComponent;
