/* eslint-disable @typescript-eslint/no-explicit-any */
import { FormikProps } from "formik";
import { SwalComponentFormData } from "../types";
import { FormInputVariations } from "../../FormInput/types";
import { AlertTypes } from "../../../hooks/useRnSwal/useRnSwal.d";
import { CheckCircleOutline, Close, InfoOutlined } from "@mui/icons-material";
import { PRIMARY_COLOR } from "@/styles/constants";

export const initialStateSwalComponentForm: SwalComponentFormData = {
  selectedButton: "",
};

export const keysSwalComponentForm = [
  "iconByType",
  "header1",
  "texts",
  "submit",
];

export const SwalComponentFormInputs =
  (
    cancel: () => any,
    type: AlertTypes,
    title: string,
    text?: string,
    text2?: string,
    text3?: string
  ) =>
  (
    _key: keyof SwalComponentFormData,
    formikMetadata: FormikProps<SwalComponentFormData>,
    t: any
  ): Record<keyof SwalComponentFormData | string, FormInputVariations> => {
    const { submitForm } = formikMetadata;

    const inputs: Record<
      keyof SwalComponentFormData | string,
      FormInputVariations
    > = {
      iconByType: {
        type: "children",
        children: (
          <>
            {type === "error" && (
              <Close
                style={{ fontSize: "80px", color: "red", margin: "0 auto" }}
              />
            )}
            {type === "success" && (
              <CheckCircleOutline
                style={{ fontSize: "80px", color: "green", margin: "0 auto" }}
              />
            )}
            {type === "accept_or_deny" && (
              <InfoOutlined
                style={{ fontSize: 62, margin: "0 auto" }}
                color="primary"
              />
            )}
          </>
        ),
      },
      header1: {
        type: "title_and_subtitle",
        texts: {
          title: t(title),
          subtitle: text ? t(text) : undefined,
        },
      },
    };

    if (type === "info" && (text2 || text3)) {
      inputs.texts = {
        type: "children",
        children: (
          <>
            {text2 && <p>{text2}</p>}
            {text3 && <p>{text3}</p>}
          </>
        ),
      };
    }

    if (type === "error") {
      inputs.submit = {
        type: "accept_and_cancel",
        cancel: {
          onClick: cancel,
          children: t("cancel"),
          variant: "contained",
          // color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundColor: "#FFF",
            borderRadius: "10px",
            maxWidth: "428px",
            display: "flex",
            flexDirection: "row",
            justifyContent: "center",
            color: "#7a7a7a",
            alignItems: "center",
            boxShadow: `0px 0px 10px #e7e7e7`,
          },
        },
        accept: {
          onClick: submitForm,
          children: t("continue"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundColor: "#FE2D2D",
            borderRadius: "10px",
            maxWidth: "428px",
            display: "flex",
            color: "#fff",
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            boxShadow: "0px 4px 6px rgba(254, 45, 45, 0.12)",
          },
        },
      };
    }

    if (type === "accept_or_deny") {
      inputs.submit = {
        type: "accept_and_cancel",
        cancel: {
          onClick: cancel,
          children: t("cancel"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundColor: "#FFF",
            borderRadius: "10px",
            maxWidth: "428px",
            display: "flex",
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            color: "#7a7a7a",
            boxShadow: `0px 0px 10px #e7e7e7`,
          },
        },
        accept: {
          onClick: submitForm,
          children: t("accept"),
          variant: "contained",
          color: "primary",
          style: {
            width: "100%",
            height: "50px",
            backgroundColor: PRIMARY_COLOR,
            borderRadius: "10px",
            maxWidth: "428px",
            display: "flex",
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            boxShadow: `0px 4px 6px ${PRIMARY_COLOR}1f`,
            color: "#fff",
          },
        },
      };
    }

    if (type === "success") {
      inputs.submit = {
        type: "button",
        button: {
          onClick: submitForm ?? cancel,
          children: t("accept"),
          variant: "contained",
          color: "primary",
          disableElevation: true,
          style: {
            width: "100%",
            height: "50px",
            backgroundColor: PRIMARY_COLOR,
            borderRadius: "100px",
            maxWidth: "428px",
            display: "flex",
            flexDirection: "row",
            justifyContent: "center",
            alignItems: "center",
            color: "#fff",
          },
        },
      };
    }

    return {
      ...inputs,
    };
  };
