import React from "react";
import styles from "./styles/TitleAndSubtitleStyles.module.scss";
import FormInput from "../FormInput/FormInput";

export interface TitleAndSubtitleCompProps {
  title: string;
  subtitle?: string;
  showDivider?: boolean;
  showBottomDivider?: boolean;
  style?: React.CSSProperties;
  titleStyle?: React.CSSProperties;
  subtitleStyle?: React.CSSProperties;
}

const TitleAndSubtitle: React.FC<TitleAndSubtitleCompProps> = ({
  title,
  subtitle,
  style,
  titleStyle,
  showDivider,
  showBottomDivider,
  subtitleStyle,
}) => {
  return (
    <div className={styles.container} style={style}>
      <p className={styles.title} style={titleStyle}>
        {title}
      </p>
      {showDivider && <div className={styles.divider} />}
      {subtitle && (
        <p className={styles.subtitle} style={subtitleStyle}>
          {subtitle}
        </p>
      )}
      {showBottomDivider && (
        <div style={{ marginTop: "12px" }}>
          <FormInput
            required={false}
            variationConfig={{
              type: "divider",
            }}
          />
        </div>
      )}
    </div>
  );
};

export default TitleAndSubtitle;
