"use client";
import React, { useRef, useState } from "react";
import styles from "./styles.module.scss";
import {
  Avatar,
  Divider,
  Fade,
  ListItemIcon,
  ListItemText,
  MenuItem,
  MenuList,
  Popper,
} from "@mui/material";
import avatar from "@/assets/icons/Avatar.png";
import { KeyboardArrowDownRounded, Login } from "@mui/icons-material";
import { useTranslations } from "next-intl";
import useAuthentication from "@/hooks/useAuthentication/useAuthentication";
import { PRIMARY_COLOR } from "@/styles/constants";
import { useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";

interface UserDropDownProps {
  onLogin: () => unknown;
}

const UserDropdown: React.FC<UserDropDownProps> = ({ onLogin }) => {
  const t = useTranslations();

  const navigate = useRouter();

  const { user, logout } = useAuthentication();

  const ref = useRef<HTMLDivElement>(null);

  const [openDropdown, setOpenDropdown] = useState<HTMLDivElement | null>(null);

  const open = Boolean(openDropdown);

  const handleGotoMyProfile = () => {
    navigate.push(AllRoutes.UPDATE_PROFILE);
    setOpenDropdown(null);
  };
  const handleGotoMyProperties = () => {
    navigate.push(AllRoutes.MY_PROPERTIES);
    setOpenDropdown(null);
  };

  return (
    <>
      <div
        onClick={() => setOpenDropdown(openDropdown ? null : ref.current)}
        className={styles.profileCard}
      >
        <Avatar sx={{ width: "100%", height: "100%" }} src={avatar.src} />
        <div className={styles.dropdown} ref={ref}>
          <KeyboardArrowDownRounded sx={{ fontSize: "16px" }} color="primary" />
        </div>
      </div>
      {open && (
        <div className={styles.shadow} onClick={() => setOpenDropdown(null)} />
      )}
      <Popper
        open={open}
        style={{ zIndex: 10000 }}
        anchorEl={openDropdown}
        transition
      >
        {({ TransitionProps }) => (
          <Fade {...TransitionProps} timeout={350}>
            <div className={styles.popperBox}>
              <MenuList dense>
                {!user && (
                  <>
                    <MenuItem
                      onClick={() => {
                        setOpenDropdown(null);
                        onLogin();
                      }}
                      style={{ color: PRIMARY_COLOR }}
                    >
                      <ListItemIcon>
                        <Login color="primary" />
                      </ListItemIcon>
                      {t("login")}
                    </MenuItem>
                  </>
                )}
                {user && (
                  <>
                    <MenuItem onClick={handleGotoMyProfile}>
                      <ListItemText inset>{t("myProfile")}</ListItemText>
                    </MenuItem>
                    <MenuItem onClick={handleGotoMyProperties}>
                      <ListItemText inset>{t("myProperties")}</ListItemText>
                    </MenuItem>
                    <Divider />
                    <MenuItem onClick={logout} sx={{ color: "red" }}>
                      <ListItemIcon>
                        <Login sx={{ color: "red" }} />
                      </ListItemIcon>
                      {t("logout")}
                    </MenuItem>
                  </>
                )}
              </MenuList>
            </div>
          </Fade>
        )}
      </Popper>
    </>
  );
};

export default UserDropdown;
