import { UseAuthentication } from "./useAuthentication.d";

import { useAppDispatch, useAppSelector } from "@/lib/services/redux/store";
import {
  changeShowOnlyRegisterFlow,
  userLogout,
} from "@/lib/services/redux/reducers/user/userActions";
import { useRouter } from "next/navigation";
import { AllRoutes } from "@/lib/routes";

const useAuthentication = (): UseAuthentication => {
  const dispatch = useAppDispatch();
  const { userData, hideRegisterFlow, showOnlyRegisterPage } = useAppSelector(
    (state) => state.user
  );
  const navigate = useRouter();

  const logoutFunction = async () => {
    dispatch(userLogout());
    navigate.push(AllRoutes.MAIN);
  };

  const changeShowOnlyRegisterPage = (state: boolean) => {
    dispatch(changeShowOnlyRegisterFlow(state));
  };

  // const checkUserHasRoles = useCallback(
  //   (roles: Roles[]) => {
  //     return Boolean(userData?.roles?.find((d) => roles.includes(d?.label)));
  //   },
  //   [userData]
  // );

  return {
    user: userData,
    logout: logoutFunction,
    hideRegisterFlow,
    showOnlyRegisterPage,
    changeShowOnlyRegisterPage,
    // checkUserHasRoles,
  };
};

export default useAuthentication;
