import { useState } from "react";
import { Bounce, toast, ToastOptions } from "react-toastify";

const useGetAppNotications = () => {
  const [notificationsToShow] = useState([]);

  const showMessage = (message: string, type: string) => {
    const payload: ToastOptions = {
      position: "top-right",
      autoClose: 3000,
      hideProgressBar: false,
      closeOnClick: true,
      pauseOnHover: true,
      draggable: true,
      progress: undefined,
      theme: "light",
      transition: Bounce,
    };

    if (
      message.length > 0 &&
      (type == "info" || type == "error" || type == "success")
    ) {
      if (type === "info") toast.info(message, payload);
      if (type === "error") toast.error(message, payload);
      if (type === "success") toast.success(message, payload);
    }
  };

  return {
    notificationsToShow,
    showMessage,
  };
};

export default useGetAppNotications;
