import { useEffect, useState } from "react";
import { UseProperties } from "./useProperties.d";
import { useAppSelector } from "@/lib/services/redux/store";
import useRequestHandler from "../useRequestHandler/useRequestHandler";
import {
  GetPropertiesSuperFeaturedParams,
  GetPropertiesSuperFeaturedResponse,
  GetPropertiesFeaturedParams,
  GetPropertiesFeaturedResponse,
  GetPropertiesParams,
  GetPropertiesResponse,
  IPropertyFeatured,
} from "@/lib/services/redux/reducers/properties/propertiesActions.d";
import {
  getPropertyFeatured,
  getPropertySuperFeatured,
  getProperties,
} from "@/lib/services/redux/reducers/properties/propertiesActions";

const useProperties = (): UseProperties => {
  const [propertiesSuperFeaturedMapped, setPropertiesSuperFeaturedMapped] =
    useState<IPropertyFeatured[]>([]);
  const [propertiesFeaturedMapped, setPropertiesFeaturedMapped] = useState<
    IPropertyFeatured[]
  >([]);
  const [propertiesMapped, setPropertiesMapped] = useState<IPropertyFeatured[]>(
    []
  );

  const {
    getPropertySuperFeatured: { propertiesSuperFeatured },
    getPropertyFeatured: { propertiesFeatured },
    getProperties: { properties, totalProperties },
  } = useAppSelector((state) => state.property);

  const {
    fetcher: getPropertiesSuperFeaturedFetch,
    requestStatus: propertiesSuperFeaturedStatus,
  } = useRequestHandler<
    GetPropertiesSuperFeaturedResponse,
    GetPropertiesSuperFeaturedParams
  >(getPropertySuperFeatured);

  const {
    fetcher: getPropertiesFeaturedFetch,
    requestStatus: propertiesFeaturedStatus,
  } = useRequestHandler<
    GetPropertiesFeaturedResponse,
    GetPropertiesFeaturedParams
  >(getPropertyFeatured);

  const { fetcher: getPropertiesFetch, requestStatus: propertiesStatus } =
    useRequestHandler<GetPropertiesResponse, GetPropertiesParams>(
      getProperties
    );

  useEffect(() => {
    if (propertiesSuperFeaturedStatus.error) {
      console.error(
        "error-getting-properties-super-featured: ",
        propertiesSuperFeaturedStatus.error
      );
    }
    if (propertiesFeaturedStatus.error) {
      console.error(
        "error-getting-properties-featured: ",
        propertiesFeaturedStatus.error
      );
    }
    if (propertiesStatus.error) {
      console.error("error-getting-properties: ", propertiesStatus.error);
    }
  }, [
    propertiesSuperFeaturedStatus,
    propertiesFeaturedStatus,
    propertiesStatus,
  ]);

  useEffect(() => {
    if (propertiesSuperFeatured) {
      setPropertiesSuperFeaturedMapped(propertiesSuperFeatured);
    }
  }, [propertiesSuperFeatured]);

  useEffect(() => {
    if (propertiesFeatured) {
      setPropertiesFeaturedMapped(propertiesFeatured);
    }
  }, [propertiesFeatured]);

  useEffect(() => {
    if (properties) {
      setPropertiesMapped(properties);
    }
  }, [properties]);

  const refetchPropertiesSuperFeatured = () => {
    getPropertiesSuperFeaturedFetch({ user_id: "" });
  };
  const refetchPropertiesFeatured = () => {
    getPropertiesFeaturedFetch({ user_id: "" });
  };

  const fetchProperties = async (
    offset?: number,
    limit?: number,
    type_id?: string,
    rooms?: number,
    bathrooms?: number,
    parking?: number,
    min_price?: number,
    max_price?: number,
    min_land_area?: number,
    max_land_area?: number,
    max_built_area?: number,
    min_built_area?: number,
    set_id?: string,
    category_id?: string,
    search?: string,
    orientation?: "vertical" | "horizontal"
  ) => {
    const property = await getPropertiesFetch({
      user_id: "",
      offset,
      limit,
      type_id,
      rooms,
      bathrooms,
      parking,
      min_price,
      max_price,
      min_land_area,
      max_land_area,
      max_built_area,
      min_built_area,
      set_id,
      category_id,
      search,
      orientation,
    });

    if (property.status === "success") {
      return property.response.properties;
    } else {
      return [];
    }
  };

  return {
    refetchPropertiesSuperFeatured,
    refetchPropertiesFeatured,
    fetchProperties,
    properties: propertiesMapped,
    propertiesSuperFeatured: propertiesSuperFeaturedMapped,
    propertiesFeatured: propertiesFeaturedMapped,
    loadingPropertiesSuperFeatured: propertiesSuperFeaturedStatus.loading,
    loadingPropertiesFeatured: propertiesFeaturedStatus.loading,
    loadingProperties: propertiesStatus.loading,
    totalProperties,
  };
};

export default useProperties;
