export interface SuccessRequest<T> {
  status: "success";
  response: T;
}

export interface ErrorRequest {
  status: "error";
  response?: string | string[];
}

export type UseRequestHandlerTypedResponse<T> =
  | SuccessRequest<T>
  | ErrorRequest;

export interface UseRequestHandler<T> {
  fetcher: (
    props: R,
    showSuccess?: boolean
  ) => Promise<UseRequestHandlerTypedResponse<T>>;
  requestStatus: {
    loading: boolean;
    success: boolean;
    error?: string | string[];
  };
}
