/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable react-hooks/exhaustive-deps */
import { useEffect, useState } from "react";
import {
  UseRequestHandler,
  UseRequestHandlerTypedResponse,
} from "./useRequestHandler.d";
import { AsyncThunk } from "@reduxjs/toolkit";
import useGetAppNotications from "../useGetAppNotifications/useGetAppNotifications";
import { useAppDispatch } from "@/lib/services/redux/store";
import useFetchingContext from "@/lib/services/context/hook";
import { LaravelSuccessResponseObject } from "@/types/main/types";

const useRequestHandler = <T = any, R = any>(
  thunk: AsyncThunk<T, any, any>
): UseRequestHandler<T> => {
  const dispatch = useAppDispatch();
  const fContext = useFetchingContext();

  const [loading, setLoading] = useState<boolean>(false);
  const [success, setSuccess] = useState<boolean>(false);
  const [error, setError] = useState<string | string[] | undefined>();

  const { showMessage } = useGetAppNotications();

  const handleFetcher = async (
    props: R,
    showSuccess?: boolean
  ): Promise<UseRequestHandlerTypedResponse<T>> => {
    try {
      setSuccess(false);
      setLoading(true);

      const response = await dispatch(
        thunk({
          ...props,
          context: fContext,
        })
      );

      if (response.type.includes("rejected")) {
        throw response.payload;
      }

      const payload: LaravelSuccessResponseObject =
        response.payload as LaravelSuccessResponseObject;

      setLoading(false);

      if (showSuccess && payload?.data?.message) {
        showMessage(payload?.data?.message, "success");
      }

      setSuccess(true);
      setTimeout(() => {
        setSuccess(false);
      }, 2000);
      return {
        status: "success",
        response: (payload?.data ?? payload) as T,
      };
    } catch (err: any) {
      setLoading(false);
      setError(err);
      return {
        status: "error",
        response: error,
      };
    }
  };

  useEffect(() => {
    if (error && error?.toString()) {
      showMessage(error?.toString(), "error");
    }
  }, [error]);

  return {
    fetcher: handleFetcher,
    requestStatus: {
      loading,
      success,
      error,
    },
  };
};

export default useRequestHandler;
