import { useDispatch } from "react-redux";

import { UseRNSwal } from "./useRnSwal.d";
import {
  clearSwal,
  showAlertAction,
  showTooltipAction,
} from "@/lib/services/redux/reducers/swal/swalActions";
import { useAppSelector } from "@/lib/services/redux/store";

const useRnSwal = (): UseRNSwal => {
  const dispatch = useDispatch();
  const {
    modal: { open },
  } = useAppSelector(({ swal }) => swal);

  const showTooltip: UseRNSwal["showTooltip"] = (text: string) => {
    dispatch(
      showTooltipAction({
        title: "Info",
        text,
      })
    );
  };

  const showAlert: UseRNSwal["showAlert"] = (
    type,
    title,
    text1,
    text2,
    text3,
    okFunction,
    cancel
  ) => {
    dispatch(
      showAlertAction({
        type,
        title,
        text1,
        text2,
        text3,
        okFunction: okFunction ? okFunction : () => "",
        cancel: cancel ? cancel : () => "",
      })
    );
  };

  const clearAll = () => {
    dispatch(clearSwal());
  };

  return {
    showTooltip,
    showAlert,
    openModal: open,
    clearAll,
  };
};

export default useRnSwal;
