export enum AllRoutes {
  MAIN = "/",
  ABOUT_US = "/about-us",
  RESULTS_VIEW = "/results",
  REGISTER = "/register",
  PROFILE = "/profile",
  MY_PROPERTIES = "/my-properties",
  CREATE_PROPERTY = "/create-property",
  PROPERTY = "/property",
  UPDATE_PROFILE = "/update-profile",
}

export interface RouteProps {
  path: AllRoutes | string;
  exact?: boolean;
  private: boolean;
}

export const RoutesConfig: RouteProps[] = [
  {
    path: AllRoutes.MAIN,
    private: false,
  },
  {
    path: AllRoutes.ABOUT_US,
    private: false,
  },
  {
    path: AllRoutes.RESULTS_VIEW,
    private: false,
  },
  {
    path: AllRoutes.REGISTER,
    private: false,
  },
  {
    path: AllRoutes.PROFILE,
    private: true,
  },
  {
    path: AllRoutes.MY_PROPERTIES,
    private: true,
  },
  {
    path: AllRoutes.CREATE_PROPERTY,
    private: true,
  },
  {
    path: AllRoutes.UPDATE_PROFILE,
    private: true,
  },
];

export const headerLinks = [AllRoutes.MAIN, AllRoutes.ABOUT_US].map(
  (d, index) => {
    return {
      link: d,
      name: Object.keys(AllRoutes)[index],
    };
  }
);
