/* eslint-disable @typescript-eslint/no-empty-object-type */
import { ReduxToolkitThunkWithContext } from "@/types/main/types";

export interface GetCountryPhoneCodesParams
  extends ReduxToolkitThunkWithContext {}

export interface GetCountryPhoneCodesResponse {
  countries: {
    phonecode: string;
    name: string;
    iso2: string;
    id: string;
    identification: number;
  }[];
}

export interface GetCountriesParams extends ReduxToolkitThunkWithContext {}

export interface GetCountriesResponse {
  countries: {
    id: string;
    name: string;
    latitude: string;
    longitude: string;
  }[];
}

export interface GetStatesParams extends ReduxToolkitThunkWithContext {
  country: string;
}

export interface GetStatesResponse {
  states: {
    id: string;
    latitude: string;
    longitude: string;
    name: string;
  }[];
}

export interface GetCitiesParams extends ReduxToolkitThunkWithContext {
  country: string;
  state: string;
}

export interface GetCitiesResponse {
  cities: {
    id: string;
    latitude: string;
    longitude: string;
    name: string;
  }[];
}
