/* eslint-disable @typescript-eslint/no-empty-object-type */
import { PropertyFromEasyBroker } from "@/components/ImportModal/components/EasyBrokerKeysCrud/components/ViewImportationsEasyBrokerModal/types";
import { KeyObject } from "@/components/ImportModal/components/EasyBrokerKeysCrud/types";
import { ReduxToolkitThunkWithContext } from "@/types/main/types";

export interface IProperty {
  precio: number;
  comisiones: number;
  comisiontotal: number;
  isVideo: boolean;
  video: string;
  lat: number;
  lng: number;
  titulo: string;
  descripcion: string;
  direccion: string;
  usuario: string;
  categoria: string;
  tipoPropiedad: string;
  AA: boolean;
  agua: boolean;
  amueblado: boolean;
  antiguedad: number | null;
  baños: number;
  camas: boolean;
  closet: boolean;
  cocina: boolean;
  comedor: boolean;
  escuelas: boolean;
  estufa: boolean;
  gas: boolean;
  habitaciones: number;
  horno: boolean;
  internet: boolean;
  lavadora: boolean;
  luz: boolean;
  m2Construidos: number;
  m2Terreno: number;
  discapacitados: boolean;
  mantenimiento: boolean;
  medioBaños: string;
  microondas: boolean;
  minihorno: boolean;
  otros: string | null;
  parking: number;
  piscinas: boolean;
  pisos: string;
  refrigerador: boolean;
  sala: boolean;
  secadora: boolean;
  seguridadPrivada: boolean;
  sets: string;
  alias: string | null;
  country: string;
  state: string;
  city: string;
  videoSurveillance: boolean;
  imgs: string[];
  id: string;
  isFavorite: boolean;
  isFollower: boolean;
  isSuperFeatured: boolean;
  isFeatured: boolean;
  types: {
    nombre: string;
    id: string;
  };
  categories: {
    nombre: string;
    id: string;
  };
  set: {
    nombre: string;
    id: string;
  };
  countries: {
    name: string;
    id: string;
  };
  states: {
    name: string;
    id: string;
  };
  cities: {
    name: string;
    id: string;
  };
  users: {
    nombre: string;
    apellido: string;
    facebookpage: string;
    instagram: string;
    telefonoPersonal: string;
    linkedin: string;
    sitioweb: string;
    twitter: string;
    youtube: string;
    id: string;
    totalProperties: number;
    totalFollowme: number;
  };
}

export interface GetPropertyResponse {
  properties: IProperty;
}
export interface GetPropertyParams extends ReduxToolkitThunkWithContext {
  hash: string;
}

export interface IPropertyFeatured {
  titulo: string;
  descripcion: string;
  precio: number;
  baños: number;
  habitaciones: number;
  parking: number;
  pisos: number | string; // en tu objeto es número
  categoria: string;
  imgs: string[];
  slug: string;
  categories: {
    nombre: string;
    id: string;
  };
  usuario: string;
  users: {
    nombre: string;
    apellido: string;
    img: string;
    id: string;
    totalProperties: number;
    totalFollowme: number;
  };
  id: string;
  isFavorite: boolean;
  isFollower: boolean;
  isSuperFeatured: boolean;
  isFeatured: boolean;

  // Nuevas propiedades:
  agua: boolean | null;
  discapacitados: boolean | null;
  escuelas: boolean | null;
  gas: boolean | null;
  internet: boolean | null;
  luz: boolean | null;
  m2Construidos: number;
  m2Terreno: number;
  mantenimiento: number | null;
  piscinas: boolean | null;
  seguridadPrivada: boolean | null;
  city: string;
  state: string;
}

export interface GetPropertiesSuperFeaturedResponse {
  properties: IPropertyFeatured[];
}
export interface GetPropertiesSuperFeaturedParams
  extends ReduxToolkitThunkWithContext {
  user_id: string;
}

export interface GetPropertiesFeaturedResponse {
  properties: IPropertyFeatured[];
}
export interface GetPropertiesFeaturedParams
  extends ReduxToolkitThunkWithContext {
  user_id: string;
}

export interface GetPropertiesResponse {
  properties: IPropertyFeatured[];
  total?: number;
}
export interface GetPropertiesParams extends ReduxToolkitThunkWithContext {
  user_id: string;
  offset: number;
  limit: number;
  type_id: string;
  rooms: number;
  bathrooms: number;
  parking: number;
  min_price: number;
  max_price: number;
  min_land_area: number;
  max_land_area: number;
  max_built_area: number;
  min_built_area: number;
  set_id: string;
  category_id: string;
  search: string;
  orientation: "vertical" | "horizontal";
  city_id: string;
  state_id: string;
  colony_id: string;
}

export interface GetPropertTypesResponse {
  types: {
    nombre: string;
    id: string;
  }[];
  total?: number;
}
export interface GetPropertTypesParams extends ReduxToolkitThunkWithContext {}
export interface GetPropertCategoriesResponse {
  categories: {
    nombre: string;
    id: string;
  }[];
  total?: number;
}
export interface GetPropertCategoriesParams
  extends ReduxToolkitThunkWithContext {}

export interface GetPropertUrbTypesResponse {
  sets: {
    nombre: string;
    id: string;
  }[];
  total?: number;
}
export interface GetPropertUrbTypesParams
  extends ReduxToolkitThunkWithContext {}

export interface CreatePropertyResponse {
  properties: null;
}
export interface CreatePropertyParams extends ReduxToolkitThunkWithContext {
  title: string;
  categoryId: string;
  price: number;
  isVideo: number;
  lat: number;
  lng: number;
  typeId: string;
  description: string;
  isAa: number;
  isWater: number;
  isFurnished: number;
  baths: number;
  isBeds: number;
  isCloset: number;
  isKitchen: number;
  isDiningRoom: number;
  others?: string;
  isDisabled: number;
  isSchool: number;
  isStove: number;
  isGas: number;
  rooms: number;
  isOven: number;
  isWifi: number;
  isWashingMachine: number;
  isLight: number;
  m2Build: number;
  m2Property: number;
  isMaintenance: number;
  halfbaths: number;
  isMicrowave: number;
  isMiniOven: number;
  parking: number;
  isSwimmingPool: number;
  level: number;
  isRefrigerator: number;
  isLivingRoom: number;
  isDryingMachine: number;
  isVideoSurveillance: number;
  isPrivateSecurity: number;
  countryId: string;
  stateId: string;
  cityId: string;
  setId: string;

  // Imagenes
  images: {
    url: string;
    type: string; // "file" o similar
    order: number;
    isDeleted: number;
  }[];

  // Videos
  videos: {
    url: string;
    type: string;
    isDeleted: number;
  }[];

  // Opcionales
  alias?: string;
  antiquity?: string;
}

export interface GenerateWithAiParams extends ReduxToolkitThunkWithContext {
  title: string;
  typeId: string;
  categoryId: string;
  setId: string;
  countryId: string;
  stateId: string;
  cityId: string;
  antiquity: string;
  m2Property: string;
  baths: string;
  parking: string;
  isWater: string;
  isGas: string;
  isPrivateSecurity: string;
  isMaintenance: string;
  isVideoSurveillance: string;
  m2Build: string;
  rooms: string;
  halfbaths: string;
  level: string;
  isLight: string;
  isWifi: string;
  isSchool: string;
  isSwimmingPool: string;
  isDisabled: string;
  isFurnished: string;
  isBeds: string;
  isLivingRoom: string;
  isKitchen: string;
  isRefrigerator: string;
  isMicrowave: string;
  isOven: string;
  isDryingMachine: string;
  others: string;
  isCloset: string;
  isDiningRoom: string;
  isAa: string;
  isStove: string;
  isMiniOven: string;
  isWashingMachine: string;
  details: string;
}

export interface GenerateWithAiResponse {
  description: string;
  total: number;
}

export interface EasyBrokersParams extends ReduxToolkitThunkWithContext {
  offset: number;
  limit: number;
}
export interface EasyBrokersResponse {
  easybrokers: KeyObject[];
  total: number;
}
export interface EasyBrokersPropertiesParams
  extends ReduxToolkitThunkWithContext {
  page: number;
  id: string;
}
export interface EasyBrokersPropertiesResponse {
  properties: PropertyFromEasyBroker[];
  total: number;
  allIds: string[];
}
export interface EasyBrokersPropertiesAllTagsResponse {
  array: string[];
}

export interface AddKeyParams extends ReduxToolkitThunkWithContext {
  name: string;
  key: string;
}

export interface AddKeyResponse {
  easybrokers: {
    status: boolean;
    name: string;
    key: string;
    user: string;
    id: string;
  }[];
}

export interface UpdateKeyParams extends ReduxToolkitThunkWithContext {
  name: string;
  key: string;
  id: string;
}

export interface UpdateKeyResponse {
  easybrokers: {
    status: boolean;
    name: string;
    key: string;
    user: string;
    id: string;
  }[];
}
export interface DeleteKeyParams extends ReduxToolkitThunkWithContext {
  id: string;
}

export interface DeleteKeyResponse {
  easybrokers: {
    status: boolean;
    name: string;
    key: string;
    user: string;
    id: string;
  }[];
}

export interface GetPropertyFromEasyBrokerParams
  extends ReduxToolkitThunkWithContext {
  id: string;
  public_id: string;
}

export interface GetPropertyFromEasyBrokerResponse {
  properties: PropertyFromEasyBrokertFull[];
}

export interface CreatePropertyFromEasyBrokerParams
  extends ReduxToolkitThunkWithContext {
  apiKey: string;
  type: "easybroker" | "excel";
  data: string;
  categoryId: string;
  typeId: string;
  setId: string;
  price: number; // mínimo 0
  m2Build: number; // mínimo 0
  m2Property: number; // mínimo 0
  isWater: 0 | 1;
  isLight: 0 | 1;
  isGas: 0 | 1;
  isWifi: 0 | 1;
  isPrivateSecurity: 0 | 1;
  isSchool: 0 | 1;
  isMaintenance: 0 | 1;
  isSwimmingPool: 0 | 1;
  isAa: 0 | 1;
  isVideoSurveillance: 0 | 1;
  isDisabled: 0 | 1;
  isBeds: 0 | 1;
  isFurnished: 0 | 1;
  isCloset: 0 | 1;
  isDryingMachine: 0 | 1;
  isLivingRoom: 0 | 1;
  isDiningRoom: 0 | 1;
  isOven: 0 | 1;
  isKitchen: 0 | 1;
  isRefrigerator: 0 | 1;
  isStove: 0 | 1;
  isMicrowave: 0 | 1;
  isMiniOven: 0 | 1;
  isWashingMachine: 0 | 1;
  alias?: string; // opcional
  antiquity?: string; // opcional
  others?: string; // opcional
}

export interface CreatePropertyFromEasyBrokerResponse {
  propertiesByKeys: null;
}

export interface UpdatePropertyFromEasyBrokerParams
  extends ReduxToolkitThunkWithContext {
  apiKey: string;
  type: "easybroker" | "excel";
  data: string;
  categoryId: string;
  typeId: string;
  setId: string;
  price: number; // mínimo 0
  m2Build: number; // mínimo 0
  m2Property: number; // mínimo 0
  isWater: 0 | 1;
  isLight: 0 | 1;
  isGas: 0 | 1;
  isWifi: 0 | 1;
  isPrivateSecurity: 0 | 1;
  isSchool: 0 | 1;
  isMaintenance: 0 | 1;
  isSwimmingPool: 0 | 1;
  isAa: 0 | 1;
  isVideoSurveillance: 0 | 1;
  isDisabled: 0 | 1;
  isBeds: 0 | 1;
  isFurnished: 0 | 1;
  isCloset: 0 | 1;
  isDryingMachine: 0 | 1;
  isLivingRoom: 0 | 1;
  isDiningRoom: 0 | 1;
  isOven: 0 | 1;
  isKitchen: 0 | 1;
  isRefrigerator: 0 | 1;
  isStove: 0 | 1;
  isMicrowave: 0 | 1;
  isMiniOven: 0 | 1;
  isWashingMachine: 0 | 1;
  alias?: string; // opcional
  antiquity?: string; // opcional
  others?: string; // opcional
}

export interface UpdatePropertyFromEasyBrokerResponse {
  propertiesByKeys: null;
}

export interface ImportPropertyParams extends ReduxToolkitThunkWithContext {
  type: "easybroker" | "excel";
  selection: string;
  dataId: string;
}

export interface ImportPropertyResponse {
  properties: null;
}

export interface getPropertyCompleteParams
  extends ReduxToolkitThunkWithContext {
  type: "easybroker" | "excel";
  data: string;
}

export interface getPropertyCompleteResponse {
  propertiesByKeys: null;
}

export interface HandleExcelsParams extends ReduxToolkitThunkWithContext {
  excel: CustomDocumentPickerResponse;
  zip: CustomDocumentPickerResponse;
}

export interface HandleExcelsResponse {
  excel: null;
  array: string[];
}

export interface getSeoIndexParams extends ReduxToolkitThunkWithContext {
  limit: number;
  variation: "cities" | "states" | "cdmx" | "location";
}

export interface SeoProperties {
  id: string;
  name: string;
  total: number;
  category: string;
  types: {
    house: {
      id: string;
      name: string;
    };
    department: {
      id: string;
      name: string;
    };
  };
  origin: "city" | "colony" | "state";
}

export interface getSeoIndexResponse {
  properties_by_rent: SeoProperties[];
  properties_by_sale: SeoProperties[];
}
